/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.mob;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.tslat.aoa3.client.render.entity.layer.CustomCreeperChargeRenderLayer;
import net.tslat.aoa3.entity.mob.creeponia.AoACreeponiaCreeper;

public class CreeponiaCreeperRenderer
extends MobRenderer<AoACreeponiaCreeper, EntityModel<AoACreeponiaCreeper>> {
    private final ResourceLocation texture;
    private final float scale;

    public CreeponiaCreeperRenderer(EntityRendererManager renderManager, EntityModel<AoACreeponiaCreeper> model, EntityModel<AoACreeponiaCreeper> expandedModel, float shadowSize, float scale, ResourceLocation texture) {
        super(renderManager, model, shadowSize);
        this.func_177094_a(new CustomCreeperChargeRenderLayer((IEntityRenderer<AoACreeponiaCreeper, EntityModel<AoACreeponiaCreeper>>)this, expandedModel));
        this.texture = texture;
        this.scale = scale;
    }

    protected void preRenderCallback(AoACreeponiaCreeper entity, MatrixStack matrix, float partialTicks) {
        float flashIntensity = entity.getCreeperFlashIntensity(partialTicks);
        float flashRatio = 1.0f + MathHelper.func_76126_a((float)(flashIntensity * 100.0f)) * flashIntensity * 0.01f;
        flashIntensity = MathHelper.func_76131_a((float)flashIntensity, (float)0.0f, (float)1.0f);
        flashIntensity *= flashIntensity;
        flashIntensity *= flashIntensity;
        float horizontalScale = (1.0f + flashIntensity * 0.4f) * flashRatio;
        float yScale = (1.0f + flashIntensity * 0.1f) / flashRatio;
        matrix.func_227862_a_(this.scale, this.scale, this.scale);
        matrix.func_227862_a_(horizontalScale, yScale, horizontalScale);
    }

    protected float getOverlayProgress(AoACreeponiaCreeper livingEntityIn, float partialTicks) {
        float flashIntensity = livingEntityIn.getCreeperFlashIntensity(partialTicks);
        return (int)(flashIntensity * 10.0f) % 2 == 0 ? 0.0f : MathHelper.func_76131_a((float)flashIntensity, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getEntityTexture(AoACreeponiaCreeper entity) {
        return this.texture;
    }
}

