/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.projectile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.tslat.aoa3.util.NumberUtil;

public class ModelledProjectileRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final ResourceLocation texture;
    protected final EntityModel<? super T> model;

    public ModelledProjectileRenderer(EntityRendererManager renderManager, EntityModel<? super T> model, ResourceLocation texture) {
        super(renderManager);
        this.model = model;
        this.texture = texture;
    }

    public void func_225623_a_(T entity, float yaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
        matrix.func_227860_a_();
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.preRenderCallback(entity, matrix, partialTicks);
        float pitch = MathHelper.func_219799_g((float)partialTicks, (float)((Entity)entity).field_70127_C, (float)((Entity)entity).field_70125_A);
        this.model.func_212843_a_(entity, 0.0f, 0.0f, partialTicks);
        this.model.func_225597_a_(entity, 0.0f, 0.0f, (float)((Entity)entity).field_70173_aa, 0.0f, pitch);
        matrix.func_227861_a_(0.0, (double)-1.3f, 0.0);
        boolean visible = !entity.func_82150_aj();
        boolean shade = !visible && !entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        RenderType rendertype = this.getRenderType(entity, visible, shade);
        if (rendertype != null) {
            IVertexBuilder ivertexbuilder = buffer.getBuffer(rendertype);
            this.model.func_225598_a_(matrix, ivertexbuilder, packedLight, NumberUtil.RGB(255, 255, 255), 1.0f, 1.0f, 1.0f, shade ? 0.15f : 1.0f);
        }
        matrix.func_227865_b_();
        super.func_225623_a_(entity, yaw, partialTicks, matrix, buffer, packedLight);
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean visible, boolean shade) {
        ResourceLocation texture = this.func_110775_a(entity);
        if (shade) {
            return RenderType.func_228644_e_((ResourceLocation)texture);
        }
        if (visible) {
            return this.model.func_228282_a_(texture);
        }
        return entity.func_225510_bt_() ? RenderType.func_228654_j_((ResourceLocation)texture) : null;
    }

    protected void preRenderCallback(T entity, MatrixStack matrix, float partialTicks) {
    }

    public ResourceLocation func_110775_a(T entity) {
        return this.texture;
    }
}

