/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.command.EnumArgument;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.util.StringUtil;

public class EventCommand
implements Command<CommandSource> {
    private static final EventCommand CMD = new EventCommand();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"events").executes((Command)CMD);
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").requires(command -> command.func_197034_c(0))).executes(EventCommand::listEvents));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"check").requires(command -> command.func_197034_c(0))).executes(context -> EventCommand.checkEvents((CommandContext<CommandSource>)context, null))).then(Commands.func_197056_a((String)"event", (ArgumentType)EnumArgument.enumArgument(OverworldEvents.Event.class)).executes(context -> EventCommand.checkEvents((CommandContext<CommandSource>)context, (OverworldEvents.Event)((Object)((Object)context.getArgument("event", OverworldEvents.Event.class)))))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"start").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"event", (ArgumentType)EnumArgument.enumArgument(OverworldEvents.Event.class)).executes(EventCommand::startEvent)));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"stop").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"event", (ArgumentType)EnumArgument.enumArgument(OverworldEvents.Event.class)).executes(EventCommand::stopEvent)));
        return builder;
    }

    private static int listEvents(CommandContext<CommandSource> cmd) {
        AoACommand.feedback((CommandSource)cmd.getSource(), "Event", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
        AoACommand.feedback((CommandSource)cmd.getSource(), "Event", "command.aoa.event.list", AoACommand.CommandFeedbackType.SUCCESS, new String[0]);
        StringBuilder builder = new StringBuilder();
        for (OverworldEvents.Event ev : OverworldEvents.Event.values()) {
            builder.append(", ");
            builder.append(StringUtil.toTitleCase(ev.toString()));
        }
        AoACommand.feedback((CommandSource)cmd.getSource(), "Event", builder.substring(2), AoACommand.CommandFeedbackType.INFO, new String[0]);
        return 1;
    }

    private static int checkEvents(CommandContext<CommandSource> cmd, @Nullable OverworldEvents.Event checkEvent) {
        AoACommand.feedback((CommandSource)cmd.getSource(), "Event", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
        AoACommand.feedback((CommandSource)cmd.getSource(), "Event", "command.aoa.event.check", AoACommand.CommandFeedbackType.SUCCESS, new String[0]);
        if (checkEvent == null) {
            StringBuilder builder = new StringBuilder();
            for (OverworldEvents.Event ev : OverworldEvents.Event.values()) {
                if (!OverworldEvents.isEventActive(ev)) continue;
                builder.append(", ");
                builder.append(StringUtil.toTitleCase(ev.toString()));
            }
            if (builder.length() == 0) {
                builder.append("   ");
            }
            AoACommand.feedback((CommandSource)cmd.getSource(), "Event", builder.substring(2), AoACommand.CommandFeedbackType.INFO, new String[0]);
            return builder.length();
        }
        AoACommand.feedback((CommandSource)cmd.getSource(), "Event", OverworldEvents.isEventActive(checkEvent) ? "command.aoa.event.check.active" : "command.aoa.event.check.inactive", AoACommand.CommandFeedbackType.INFO, StringUtil.toTitleCase(checkEvent.toString()));
        return 1;
    }

    private static int startEvent(CommandContext<CommandSource> cmd) {
        OverworldEvents.Event ev = (OverworldEvents.Event)((Object)cmd.getArgument("event", OverworldEvents.Event.class));
        AoACommand.feedback((CommandSource)cmd.getSource(), "Event", "command.aoa.event.starting", AoACommand.CommandFeedbackType.SUCCESS, StringUtil.toTitleCase(ev.toString()));
        if (OverworldEvents.isEventActive(ev)) {
            AoACommand.error((CommandSource)cmd.getSource(), "Event", "command.aoa.event.starting.fail", StringUtil.toTitleCase(ev.toString()));
        } else {
            OverworldEvents.activateEvent(((CommandSource)cmd.getSource()).func_197028_i().func_71218_a(DimensionType.field_223227_a_), ev);
        }
        return 1;
    }

    private static int stopEvent(CommandContext<CommandSource> cmd) {
        OverworldEvents.Event ev = (OverworldEvents.Event)((Object)cmd.getArgument("event", OverworldEvents.Event.class));
        AoACommand.feedback((CommandSource)cmd.getSource(), "Event", "command.aoa.event.stopping", AoACommand.CommandFeedbackType.SUCCESS, StringUtil.toTitleCase(ev.toString()));
        if (OverworldEvents.isEventActive(ev)) {
            OverworldEvents.deactivateEvent(((CommandSource)cmd.getSource()).func_197028_i().func_71218_a(DimensionType.field_223227_a_), ev);
        } else {
            AoACommand.error((CommandSource)cmd.getSource(), "Event", "command.aoa.event.stopping.fail", StringUtil.toTitleCase(ev.toString()));
        }
        return 1;
    }

    public int run(CommandContext<CommandSource> context) {
        AoACommand.feedback((CommandSource)context.getSource(), "Event", "command.aoa.event.desc", AoACommand.CommandFeedbackType.INFO, new String[0]);
        return 1;
    }
}

