/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.server.command.EnumArgument;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.StringUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class PlayerCommand
implements Command<CommandSource> {
    private static final PlayerCommand CMD = new PlayerCommand();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"player").executes((Command)CMD);
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197057_a((String)"skills").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skills.class)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"level").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)999)).executes(context -> PlayerCommand.adjustSkills((CommandContext<CommandSource>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"subtract").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)999)).executes(context -> PlayerCommand.adjustSkills((CommandContext<CommandSource>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(context -> PlayerCommand.adjustSkills((CommandContext<CommandSource>)context, "set"))))).then(Commands.func_197057_a((String)"check").executes(PlayerCommand::checkSkill)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"xp").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)5.4413235E8f)).executes(context -> PlayerCommand.adjustXp((CommandContext<CommandSource>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"subtract").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)5.4413235E8f)).executes(context -> PlayerCommand.adjustXp((CommandContext<CommandSource>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)5.4413235E8f)).executes(context -> PlayerCommand.adjustXp((CommandContext<CommandSource>)context, "set"))))).then(Commands.func_197057_a((String)"check").executes(PlayerCommand::checkXp)))))).then(Commands.func_197057_a((String)"resources").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"resource", (ArgumentType)EnumArgument.enumArgument(Resources.class)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)200.0f)).executes(context -> PlayerCommand.adjustResources((CommandContext<CommandSource>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"subtract").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)200.0f)).executes(context -> PlayerCommand.adjustResources((CommandContext<CommandSource>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)200.0f)).executes(context -> PlayerCommand.adjustResources((CommandContext<CommandSource>)context, "set"))))).then(Commands.func_197057_a((String)"check").executes(PlayerCommand::checkResource))))).then(Commands.func_197057_a((String)"tribute").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"deity", (ArgumentType)EnumArgument.enumArgument(Deities.class)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(context -> PlayerCommand.adjustTribute((CommandContext<CommandSource>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"subtract").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(context -> PlayerCommand.adjustTribute((CommandContext<CommandSource>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(context -> PlayerCommand.adjustTribute((CommandContext<CommandSource>)context, "set"))))).then(Commands.func_197057_a((String)"check").executes(PlayerCommand::checkTribute))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"stats").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"experience").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> PlayerCommand.adjustVanillaXp((CommandContext<CommandSource>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"subtract").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> PlayerCommand.adjustVanillaXp((CommandContext<CommandSource>)context, "subtract"))))).then(Commands.func_197057_a((String)"check").executes(PlayerCommand::checkVanillaXp)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"food").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"hunger").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSource>)context, "hunger", "add"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"subtract").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSource>)context, "hunger", "subtract"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSource>)context, "hunger", "set"))))).then(Commands.func_197057_a((String)"check").executes(context -> PlayerCommand.checkFoodStats((CommandContext<CommandSource>)context, "hunger"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"saturation").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSource>)context, "saturation", "add"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"subtract").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSource>)context, "saturation", "subtract"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSource>)context, "saturation", "set"))))).then(Commands.func_197057_a((String)"check").executes(context -> PlayerCommand.checkFoodStats((CommandContext<CommandSource>)context, "saturation")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"health").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.1474836E9f)).executes(context -> PlayerCommand.adjustHealth((CommandContext<CommandSource>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"subtract").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.1474836E9f)).executes(context -> PlayerCommand.adjustHealth((CommandContext<CommandSource>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(command -> command.func_197034_c(4))).then(Commands.func_197056_a((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.1474836E9f)).executes(context -> PlayerCommand.adjustHealth((CommandContext<CommandSource>)context, "set"))))).then(Commands.func_197057_a((String)"check").executes(PlayerCommand::checkHealth)))));
        return builder;
    }

    private static int checkFoodStats(CommandContext<CommandSource> context, String subsection) throws CommandSyntaxException {
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        if (subsection.equals("hunger")) {
            if (pl != ((CommandSource)context.getSource()).func_197027_g()) {
                if (!((CommandSource)context.getSource()).func_197034_c(2)) {
                    throw AoACommand.NO_PERMISSION_EXCEPTION.create();
                }
                AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
                AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.food.hunger.check.other", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), String.valueOf(pl.func_71024_bL().func_75116_a()));
            } else {
                AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
                AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.food.hunger.check.self", AoACommand.CommandFeedbackType.SUCCESS, String.valueOf(pl.func_71024_bL().func_75116_a()));
            }
        } else if (pl != ((CommandSource)context.getSource()).func_197027_g()) {
            if (!((CommandSource)context.getSource()).func_197034_c(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.food.saturation.check.other", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), NumberUtil.roundToNthDecimalPlace(pl.func_71024_bL().func_75115_e(), 2));
        } else {
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.food.saturation.check.self", AoACommand.CommandFeedbackType.SUCCESS, NumberUtil.roundToNthDecimalPlace(pl.func_71024_bL().func_75115_e(), 2));
        }
        return 1;
    }

    private static int checkVanillaXp(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        if (pl != ((CommandSource)context.getSource()).func_197027_g()) {
            if (!((CommandSource)context.getSource()).func_197034_c(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.exp.check.other", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), String.valueOf(pl.field_71067_cb), String.valueOf(pl.field_71068_ca));
        } else {
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.exp.check.self", AoACommand.CommandFeedbackType.SUCCESS, String.valueOf(pl.field_71067_cb), String.valueOf(pl.field_71068_ca));
        }
        return 1;
    }

    private static int checkHealth(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        if (pl != ((CommandSource)context.getSource()).func_197027_g()) {
            if (!((CommandSource)context.getSource()).func_197034_c(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.health.check.other", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), NumberUtil.roundToNthDecimalPlace(pl.func_110143_aJ(), 2), NumberUtil.roundToNthDecimalPlace(pl.func_110138_aP(), 2));
        } else {
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.health.check.self", AoACommand.CommandFeedbackType.SUCCESS, NumberUtil.roundToNthDecimalPlace(pl.func_110143_aJ(), 2), NumberUtil.roundToNthDecimalPlace(pl.func_110138_aP(), 2));
        }
        return 1;
    }

    private static int checkSkill(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        if (pl != ((CommandSource)context.getSource()).func_197027_g()) {
            if (!((CommandSource)context.getSource()).func_197034_c(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            Skills skill = (Skills)((Object)context.getArgument("skill", Skills.class));
            int level = PlayerUtil.getAdventPlayer(pl).stats().getLevel(skill);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.skill.check.other", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), StringUtil.toTitleCase(skill.toString()), String.valueOf(level));
        } else {
            Skills skill = (Skills)((Object)context.getArgument("skill", Skills.class));
            int level = PlayerUtil.getAdventPlayer(pl).stats().getLevel(skill);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.skill.check.self", AoACommand.CommandFeedbackType.SUCCESS, StringUtil.toTitleCase(skill.toString()), String.valueOf(level));
        }
        return 1;
    }

    private static int checkXp(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        if (pl != ((CommandSource)context.getSource()).func_197027_g()) {
            if (!((CommandSource)context.getSource()).func_197034_c(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            Skills skill = (Skills)((Object)context.getArgument("skill", Skills.class));
            float xp = PlayerUtil.getAdventPlayer(pl).stats().getExp(skill);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.xp.check.other", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), StringUtil.toTitleCase(skill.toString()), String.valueOf(xp));
        } else {
            Skills skill = (Skills)((Object)context.getArgument("skill", Skills.class));
            float xp = PlayerUtil.getAdventPlayer(pl).stats().getExp(skill);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.xp.check.self", AoACommand.CommandFeedbackType.SUCCESS, StringUtil.toTitleCase(skill.toString()), String.valueOf(xp));
        }
        return 1;
    }

    private static int checkResource(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        if (pl != ((CommandSource)context.getSource()).func_197027_g()) {
            if (!((CommandSource)context.getSource()).func_197034_c(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            Resources resource = (Resources)((Object)context.getArgument("resource", Resources.class));
            float value = PlayerUtil.getAdventPlayer(pl).stats().getResourceValue(resource);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.resource.check.other", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), String.valueOf(value), StringUtil.toTitleCase(resource.toString()));
        } else {
            Resources resource = (Resources)((Object)context.getArgument("resource", Resources.class));
            float value = PlayerUtil.getAdventPlayer(pl).stats().getResourceValue(resource);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.resource.check.self", AoACommand.CommandFeedbackType.SUCCESS, StringUtil.toTitleCase(resource.toString()), String.valueOf(value));
        }
        return 1;
    }

    private static int checkTribute(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        if (pl != ((CommandSource)context.getSource()).func_197027_g()) {
            if (!((CommandSource)context.getSource()).func_197034_c(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            Deities deity = (Deities)((Object)context.getArgument("deity", Deities.class));
            int value = PlayerUtil.getAdventPlayer(pl).stats().getTribute(deity);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.tribute.check.other", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), String.valueOf(value), StringUtil.toTitleCase(deity.toString()));
        } else {
            Deities deity = (Deities)((Object)context.getArgument("deity", Deities.class));
            int value = PlayerUtil.getAdventPlayer(pl).stats().getTribute(deity);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.tribute.check.self", AoACommand.CommandFeedbackType.SUCCESS, StringUtil.toTitleCase(deity.toString()), String.valueOf(value));
        }
        return 1;
    }

    private static int adjustSkills(CommandContext<CommandSource> context, String operation) throws CommandSyntaxException {
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        Skills skill = (Skills)((Object)context.getArgument("skill", Skills.class));
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        PlayerDataManager.PlayerStats stats = PlayerUtil.getAdventPlayer(pl).stats();
        int adjustment = 0;
        switch (operation) {
            case "add": {
                adjustment = Math.min(value, 1000 - stats.getLevelForDisplay(skill));
                stats.setLevel(skill, stats.getLevelForDisplay(skill) + value);
                break;
            }
            case "subtract": {
                adjustment = -Math.min(value, stats.getLevelForDisplay(skill) - 1);
                stats.setLevel(skill, stats.getLevelForDisplay(skill) - value);
                break;
            }
            case "set": {
                adjustment = value - stats.getLevelForDisplay(skill);
                stats.setLevel(skill, value);
            }
        }
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.skill.adjust", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), StringUtil.toTitleCase(skill.toString()), String.valueOf(adjustment), String.valueOf(stats.getLevelForDisplay(skill)));
        return 1;
    }

    private static int adjustXp(CommandContext<CommandSource> context, String operation) throws CommandSyntaxException {
        float value = FloatArgumentType.getFloat(context, (String)"value");
        Skills skill = (Skills)((Object)context.getArgument("skill", Skills.class));
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        PlayerDataManager.PlayerStats stats = PlayerUtil.getAdventPlayer(pl).stats();
        float adjustment = value;
        switch (operation) {
            case "add": {
                stats.addXp(skill, value, true, true);
                break;
            }
            case "subtract": {
                stats.subtractXp(skill, value);
                break;
            }
            case "set": {
                float maxXpForLevel = PlayerUtil.getXpRequiredForNextLevel(stats.getLevel(skill));
                float curXp = stats.getExp(skill);
                value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)maxXpForLevel);
                adjustment = value - curXp;
                if (adjustment > 0.0f) {
                    stats.addXp(skill, adjustment, true, true);
                    break;
                }
                stats.subtractXp(skill, adjustment);
            }
        }
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.xp.adjust", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), StringUtil.toTitleCase(skill.toString()), String.valueOf(adjustment), String.valueOf(stats.getExp(skill)));
        return 1;
    }

    private static int adjustResources(CommandContext<CommandSource> context, String operation) throws CommandSyntaxException {
        float value = FloatArgumentType.getFloat(context, (String)"value");
        Resources resource = (Resources)((Object)context.getArgument("resource", Resources.class));
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        PlayerDataManager.PlayerStats stats = PlayerUtil.getAdventPlayer(pl).stats();
        float adjustment = 0.0f;
        switch (operation) {
            case "add": {
                adjustment = Math.min(value, 200.0f - stats.getResourceValue(resource));
                stats.regenResource(resource, adjustment);
                break;
            }
            case "subtract": {
                adjustment = -Math.min(value, stats.getResourceValue(resource));
                stats.consumeResource(resource, adjustment, true);
                break;
            }
            case "set": {
                adjustment = value - stats.getResourceValue(resource);
                if (adjustment >= 0.0f) {
                    stats.regenResource(resource, adjustment);
                    break;
                }
                stats.consumeResource(resource, -adjustment, true);
            }
        }
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.resource.adjust", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), StringUtil.toTitleCase(resource.toString()), String.valueOf(adjustment), String.valueOf(stats.getResourceValue(resource)));
        return 1;
    }

    private static int adjustTribute(CommandContext<CommandSource> context, String operation) throws CommandSyntaxException {
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        Deities deity = (Deities)((Object)context.getArgument("deity", Deities.class));
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        PlayerDataManager.PlayerStats stats = PlayerUtil.getAdventPlayer(pl).stats();
        int adjustment = 0;
        switch (operation) {
            case "add": {
                adjustment = Math.min(value, 200 - stats.getTribute(deity));
                stats.addTribute(deity, value);
                break;
            }
            case "subtract": {
                adjustment = -Math.min(value, stats.getTribute(deity));
                stats.consumeTribute(deity, value);
                break;
            }
            case "set": {
                adjustment = value - stats.getTribute(deity);
                if (adjustment > 0) {
                    stats.addTribute(deity, adjustment);
                    break;
                }
                stats.consumeTribute(deity, adjustment);
            }
        }
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.tribute.adjust", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), StringUtil.toTitleCase(deity.toString()), String.valueOf(adjustment), String.valueOf(stats.getTribute(deity)));
        return 1;
    }

    private static int adjustHealth(CommandContext<CommandSource> context, String operation) throws CommandSyntaxException {
        float value = FloatArgumentType.getFloat(context, (String)"amount");
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        float adjustment = 0.0f;
        switch (operation) {
            case "add": {
                adjustment = Math.min(value, pl.func_110138_aP() - pl.func_110143_aJ());
                pl.func_70606_j(pl.func_110143_aJ() + adjustment);
                break;
            }
            case "subtract": {
                adjustment = -Math.min(value, pl.func_110143_aJ());
                pl.func_70606_j(pl.func_110143_aJ() + adjustment);
                break;
            }
            case "set": {
                float newHealth = MathHelper.func_76131_a((float)value, (float)0.0f, (float)pl.func_110138_aP());
                adjustment = newHealth - pl.func_110143_aJ();
                pl.func_70606_j(newHealth);
            }
        }
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.health.adjust", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), NumberUtil.roundToNthDecimalPlace(adjustment, 2), NumberUtil.roundToNthDecimalPlace(pl.func_110143_aJ(), 2), NumberUtil.roundToNthDecimalPlace(pl.func_110138_aP(), 2));
        return 1;
    }

    private static int adjustVanillaXp(CommandContext<CommandSource> context, String operation) throws CommandSyntaxException {
        int value = IntegerArgumentType.getInteger(context, (String)"amount");
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        int adjustment = 0;
        switch (operation) {
            case "add": {
                adjustment = Math.min(value, Integer.MAX_VALUE - pl.field_71067_cb);
                pl.func_195068_e(adjustment);
                break;
            }
            case "subtract": {
                adjustment = -Math.min(value, pl.field_71067_cb);
                pl.func_195068_e(adjustment);
                break;
            }
            case "set": {
                adjustment = value - pl.field_71067_cb;
                pl.func_195068_e(adjustment);
            }
        }
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.exp.adjust", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), String.valueOf(adjustment), String.valueOf(pl.field_71067_cb), String.valueOf(pl.field_71068_ca));
        return 1;
    }

    private static int adjustFoodStats(CommandContext<CommandSource> context, String operation, String subsection) throws CommandSyntaxException {
        int value = IntegerArgumentType.getInteger(context, (String)"amount");
        ServerPlayerEntity pl = EntityArgument.func_197089_d(context, (String)"player");
        FoodStats food = pl.func_71024_bL();
        if (operation.equals("hunger")) {
            int adjustment = 0;
            switch (subsection) {
                case "add": {
                    adjustment = Math.min(value, 20 - food.func_75116_a());
                    food.func_75122_a(adjustment, 0.0f);
                    break;
                }
                case "subtract": {
                    adjustment = -Math.min(value, food.func_75116_a());
                    food.func_75114_a(food.func_75116_a() + adjustment);
                    break;
                }
                case "set": {
                    int newHunger = MathHelper.func_76125_a((int)value, (int)0, (int)20);
                    adjustment = newHunger - food.func_75116_a();
                    food.func_75114_a(newHunger);
                }
            }
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.food.adjust", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), String.valueOf(adjustment), String.valueOf(food.func_75116_a()));
        } else {
            float adjustment = 0.0f;
            switch (subsection) {
                case "add": {
                    adjustment = value;
                    food.func_75122_a(0, (float)value);
                    break;
                }
                case "subtract": {
                    adjustment = -Math.min((float)value, food.func_75115_e());
                    food.func_75122_a(0, adjustment);
                    break;
                }
                case "set": {
                    adjustment = (float)value - food.func_75115_e();
                    food.func_75122_a(0, adjustment);
                }
            }
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new String[0]);
            AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.saturation.adjust", AoACommand.CommandFeedbackType.SUCCESS, pl.func_145748_c_().func_150254_d(), String.valueOf(adjustment), String.valueOf(food.func_75115_e()));
        }
        return 1;
    }

    public int run(CommandContext<CommandSource> context) {
        AoACommand.feedback((CommandSource)context.getSource(), "Player", "command.aoa.player.desc", AoACommand.CommandFeedbackType.INFO, new String[0]);
        return 1;
    }
}

