/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.command.EnumArgument;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.util.StringUtil;
import net.tslat.aoa3.worldgen.structures.AoAStructure;
import net.tslat.aoa3.worldgen.structures.StructuresHandler;

public class StructureCommand
implements Command<CommandSource> {
    public static boolean isConverting = false;
    public static BiConsumer<BlockState, BlockPos> conversionStateConsumer;
    public static BiConsumer<ResourceLocation, BlockPos> conversionChestConsumer;
    public static BiConsumer<EntityType<?>, BlockPos> conversionSpawnerConsumer;
    public static Consumer<Entity> conversionEntityConsumer;
    private static final StructureCommand CMD;
    private Map<ResourceLocation, Template> templates = null;

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"structures").requires(sender -> sender.func_197034_c(4))).executes((Command)CMD);
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"generate").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"structure_id", (ArgumentType)StructureIdArgument.instance()).then(Commands.func_197056_a((String)"position", (ArgumentType)BlockPosArgument.func_197276_a()).executes(context -> StructureCommand.spawnStructure((CommandContext<CommandSource>)context, Mirror.NONE, Rotation.NONE, false)))).then(Commands.func_197056_a((String)"mirror", (ArgumentType)EnumArgument.enumArgument(Mirror.class)).executes(context -> StructureCommand.spawnStructure((CommandContext<CommandSource>)context, (Mirror)context.getArgument("mirror", Mirror.class), Rotation.NONE, false)))).then(Commands.func_197056_a((String)"rotation", (ArgumentType)EnumArgument.enumArgument(Rotation.class)).executes(context -> StructureCommand.spawnStructure((CommandContext<CommandSource>)context, (Mirror)context.getArgument("mirror", Mirror.class), (Rotation)context.getArgument("rotation", Rotation.class), false)))).then(Commands.func_197056_a((String)"ignore_entities", (ArgumentType)BoolArgumentType.bool()).executes(context -> StructureCommand.spawnStructure((CommandContext<CommandSource>)context, (Mirror)context.getArgument("mirror", Mirror.class), (Rotation)context.getArgument("rotation", Rotation.class), (Boolean)context.getArgument("ignore_entities", Boolean.class)))))).then(Commands.func_197057_a((String)"aoa").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"structure_name", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"position", (ArgumentType)BlockPosArgument.func_197276_a()).executes(context -> StructureCommand.spawnAoAStructure((CommandContext<CommandSource>)context, Mirror.NONE, Rotation.NONE, false)))).then(Commands.func_197056_a((String)"mirror", (ArgumentType)EnumArgument.enumArgument(Mirror.class)).executes(context -> StructureCommand.spawnAoAStructure((CommandContext<CommandSource>)context, (Mirror)context.getArgument("mirror", Mirror.class), Rotation.NONE, false)))).then(Commands.func_197056_a((String)"rotation", (ArgumentType)EnumArgument.enumArgument(Rotation.class)).executes(context -> StructureCommand.spawnAoAStructure((CommandContext<CommandSource>)context, (Mirror)context.getArgument("mirror", Mirror.class), (Rotation)context.getArgument("rotation", Rotation.class), false)))).then(Commands.func_197056_a((String)"ignore_entities", (ArgumentType)BoolArgumentType.bool()).executes(context -> StructureCommand.spawnAoAStructure((CommandContext<CommandSource>)context, (Mirror)context.getArgument("mirror", Mirror.class), (Rotation)context.getArgument("rotation", Rotation.class), (Boolean)context.getArgument("ignore_entities", Boolean.class)))))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"convert").requires(context -> !FMLEnvironment.production)).then(Commands.func_197056_a((String)"structure_name", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"ignore_air", (ArgumentType)BoolArgumentType.bool()).executes(StructureCommand::convertStructure))));
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int convertStructure(CommandContext<CommandSource> cmd) {
        String structureId = (String)cmd.getArgument("structure_name", String.class);
        boolean ignoreAir = (Boolean)cmd.getArgument("ignore_air", Boolean.class);
        AoAStructure structure = StructuresHandler.getStructure(structureId);
        if (structure == StructuresHandler.EMPTY_STRUCTURE) {
            AoACommand.feedback((CommandSource)cmd.getSource(), "Structures", "command.aoa.structures.invalidStructure", AoACommand.CommandFeedbackType.WARN, structureId);
            return 1;
        }
        try {
            StructureCommand.doStructureConversion((CommandSource)cmd.getSource(), structure, ignoreAir);
        }
        catch (Exception ex) {
            AoACommand.feedback((CommandSource)cmd.getSource(), "Structures", "Failed to convert '" + structureId + "' to NBT.", AoACommand.CommandFeedbackType.ERROR, new String[0]);
            ex.printStackTrace();
        }
        finally {
            isConverting = false;
            conversionChestConsumer = null;
            conversionStateConsumer = null;
            conversionSpawnerConsumer = null;
            conversionEntityConsumer = null;
        }
        return 1;
    }

    private static int spawnStructure(CommandContext<CommandSource> cmd, Mirror mirror, Rotation rotation, boolean ignoreEntities) throws CommandSyntaxException {
        try {
            ResourceLocation id = StructureIdArgument.getStructureId(cmd, "structure_id");
            Template template = ((MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER)).func_71218_a(DimensionType.field_223227_a_).func_184163_y().func_200219_b(id);
            BlockPos spawnPos = ((ILocationArgument)cmd.getArgument("position", ILocationArgument.class)).func_197280_c((CommandSource)cmd.getSource());
            if (template == null) {
                AoACommand.feedback((CommandSource)cmd.getSource(), "Structures", "command.aoa.structures.invalidStructure", AoACommand.CommandFeedbackType.WARN, id.toString());
                return 1;
            }
            template.func_186253_b((IWorld)((CommandSource)cmd.getSource()).func_197023_e(), spawnPos, new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation).func_186222_a(ignoreEntities).func_186218_a(null));
            AoACommand.feedback((CommandSource)cmd.getSource(), "Structures", "command.aoa.structures.spawn", AoACommand.CommandFeedbackType.SUCCESS, id.toString(), spawnPos.func_177958_n() + ", " + spawnPos.func_177956_o() + ", " + spawnPos.func_177952_p());
        }
        catch (ResourceLocationException ex) {
            AoACommand.error((CommandSource)cmd.getSource(), "Structures", ex.getLocalizedMessage(), new String[0]);
        }
        return 1;
    }

    private static int spawnAoAStructure(CommandContext<CommandSource> cmd, Mirror mirror, Rotation rotation, boolean ignoreEntities) throws CommandSyntaxException {
        try {
            String structureName = (String)cmd.getArgument("structure_name", String.class);
            BlockPos spawnPos = ((ILocationArgument)cmd.getArgument("position", ILocationArgument.class)).func_197280_c((CommandSource)cmd.getSource());
            AoAStructure structure = StructuresHandler.getStructure(structureName);
            if (structure == StructuresHandler.EMPTY_STRUCTURE) {
                AoACommand.feedback((CommandSource)cmd.getSource(), "Structures", "command.aoa.structures.invalidStructure", AoACommand.CommandFeedbackType.WARN, structureName);
                return 1;
            }
            structure.generate((IWorld)((CommandSource)cmd.getSource()).func_197023_e(), new Random(), spawnPos);
            AoACommand.feedback((CommandSource)cmd.getSource(), "Structures", "command.aoa.structures.spawn", AoACommand.CommandFeedbackType.SUCCESS, structureName, spawnPos.func_177958_n() + ", " + spawnPos.func_177956_o() + ", " + spawnPos.func_177952_p());
        }
        catch (ResourceLocationException ex) {
            AoACommand.error((CommandSource)cmd.getSource(), "Structures", ex.getLocalizedMessage(), new String[0]);
        }
        return 1;
    }

    private static ListNBT vec3iToListNbt(Vec3i vec) {
        ListNBT nbt = new ListNBT();
        nbt.add(0, (INBT)IntNBT.func_229692_a_((int)vec.func_177958_n()));
        nbt.add(0, (INBT)IntNBT.func_229692_a_((int)vec.func_177956_o()));
        nbt.add(0, (INBT)IntNBT.func_229692_a_((int)vec.func_177952_p()));
        return nbt;
    }

    private static void doStructureConversion(CommandSource source, AoAStructure structure, boolean ignoreAir) {
        ServerWorld world = source.func_197023_e();
        if (world.func_201670_d()) {
            return;
        }
        isConverting = true;
        CompoundNBT structureNbt = new CompoundNBT();
        ListNBT blocksNbt = new ListNBT();
        ListNBT entitiesNbt = new ListNBT();
        ListNBT paletteNbt = new ListNBT();
        BlockPos.Mutable sizePos = new BlockPos.Mutable(0, 0, 0);
        ArrayList states = new ArrayList();
        ArrayList<String> errors = new ArrayList<String>();
        conversionStateConsumer = (state, pos) -> {
            if (ignoreAir && state.func_177230_c() == Blocks.field_150350_a) {
                return;
            }
            CompoundNBT entry = new CompoundNBT();
            int stateId = -1;
            for (int i = 0; i < states.size(); ++i) {
                if (states.get(i) != state) continue;
                stateId = i;
                break;
            }
            if (stateId == -1) {
                stateId = states.size();
                states.add(state);
            }
            entry.func_218657_a("pos", (INBT)StructureCommand.vec3iToListNbt((Vec3i)pos));
            entry.func_74768_a("state", stateId);
            blocksNbt.add((Object)entry);
            if (sizePos.func_177958_n() < pos.func_177958_n()) {
                sizePos.func_181079_c(pos.func_177958_n(), sizePos.func_177956_o(), sizePos.func_177952_p());
            }
            if (sizePos.func_177956_o() < pos.func_177956_o()) {
                sizePos.func_181079_c(sizePos.func_177958_n(), pos.func_177956_o(), sizePos.func_177952_p());
            }
            if (sizePos.func_177952_p() < pos.func_177952_p()) {
                sizePos.func_181079_c(sizePos.func_177958_n(), sizePos.func_177956_o(), pos.func_177952_p());
            }
        };
        conversionChestConsumer = (id, pos) -> {
            for (INBT entry : blocksNbt) {
                CompoundNBT blockNbt = (CompoundNBT)entry;
                ListNBT blockPos = (ListNBT)blockNbt.func_74781_a("pos");
                if (blockPos == null) {
                    errors.add("Invalid block entry found, no pos marker exists. This is bad. " + pos.toString());
                    return;
                }
                if (!blockPos.equals((Object)StructureCommand.vec3iToListNbt((Vec3i)pos))) continue;
                CompoundNBT chestNbt = new CompoundNBT();
                int stateId = blockNbt.func_74762_e("state");
                if (stateId >= states.size()) {
                    errors.add("Invalid state id retrieved for block at " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ".");
                    return;
                }
                Block bl = ((BlockState)states.get(stateId)).func_177230_c();
                chestNbt.func_74778_a("id", bl.getRegistryName().toString());
                chestNbt.func_74778_a("LootTable", id.toString());
                blockNbt.func_218657_a("nbt", (INBT)chestNbt);
                break;
            }
        };
        conversionSpawnerConsumer = (entityType, pos) -> {
            for (INBT entry : blocksNbt) {
                CompoundNBT blockNbt = (CompoundNBT)entry;
                ListNBT blockPos = (ListNBT)blockNbt.func_74781_a("pos");
                if (blockPos == null) {
                    errors.add("Invalid block entry found, no pos marker exists. This is bad. " + pos.toString());
                    return;
                }
                if (!blockPos.equals((Object)StructureCommand.vec3iToListNbt((Vec3i)pos))) continue;
                MobSpawnerTileEntity tileEntity = new MobSpawnerTileEntity();
                CompoundNBT spawnerNbt = new CompoundNBT();
                tileEntity.func_145881_a().func_200876_a(entityType);
                tileEntity.func_226984_a_((World)world, pos);
                tileEntity.func_145881_a().func_189530_b(spawnerNbt);
                blockNbt.func_218657_a("nbt", (INBT)spawnerNbt);
                break;
            }
        };
        conversionEntityConsumer = entity -> {
            CompoundNBT entityNbt = new CompoundNBT();
            CompoundNBT entityData = new CompoundNBT();
            ListNBT posNbt = new ListNBT();
            ListNBT blockPosNbt = new ListNBT();
            Vec3d entityPos = entity.func_174791_d();
            BlockPos blockPos = entity instanceof PaintingEntity ? ((PaintingEntity)entity).func_174857_n() : entity.func_180425_c();
            posNbt.add((Object)DoubleNBT.func_229684_a_((double)entityPos.func_82615_a()));
            posNbt.add((Object)DoubleNBT.func_229684_a_((double)entityPos.func_82617_b()));
            posNbt.add((Object)DoubleNBT.func_229684_a_((double)entityPos.func_82616_c()));
            blockPosNbt.add((Object)IntNBT.func_229692_a_((int)blockPos.func_177958_n()));
            blockPosNbt.add((Object)IntNBT.func_229692_a_((int)blockPos.func_177956_o()));
            blockPosNbt.add((Object)IntNBT.func_229692_a_((int)blockPos.func_177952_p()));
            entity.func_70039_c(entityData);
            entityNbt.func_218657_a("pos", (INBT)posNbt);
            entityNbt.func_218657_a("blockPos", (INBT)blockPosNbt);
            entityNbt.func_218657_a("nbt", (INBT)entityData);
            entitiesNbt.add((Object)entityNbt);
        };
        structure.generate((IWorld)world, world.func_201674_k(), new BlockPos(0, 0, 0));
        sizePos.func_196234_d(1, 1, 1);
        if (sizePos.func_177958_n() > 48 || sizePos.func_177956_o() > 48 || sizePos.func_177952_p() > 48) {
            errors.add("Structure is too large, must fit within 32x32x32. Current size: " + sizePos.func_177958_n() + "x" + sizePos.func_177956_o() + "x" + sizePos.func_177952_p());
        }
        if (errors.isEmpty()) {
            for (BlockState state2 : states) {
                paletteNbt.add((Object)NBTUtil.func_190009_a((BlockState)state2));
            }
            structureNbt.func_218657_a("blocks", (INBT)blocksNbt);
            structureNbt.func_218657_a("entities", (INBT)entitiesNbt);
            structureNbt.func_218657_a("palette", (INBT)paletteNbt);
            structureNbt.func_218657_a("size", (INBT)StructureCommand.vec3iToListNbt((Vec3i)sizePos));
            structureNbt.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
            StructureCommand.saveStructureData(world, structure.getName(), structureNbt);
            AoACommand.feedback(source, "Structures", "Successfully converted '" + structure.getName() + "' to NBT.", AoACommand.CommandFeedbackType.SUCCESS, new String[0]);
        } else {
            AoACommand.feedback(source, "Structures", "Encountered " + errors.size() + " errors while attempting to convert. Cancelling operation", AoACommand.CommandFeedbackType.ERROR, new String[0]);
            for (String error : errors) {
                source.func_197021_a((ITextComponent)new StringTextComponent(error));
            }
        }
        isConverting = false;
        conversionChestConsumer = null;
        conversionStateConsumer = null;
        conversionSpawnerConsumer = null;
        conversionEntityConsumer = null;
    }

    private static void saveStructureData(ServerWorld world, String structureId, CompoundNBT data) {
        TemplateManager templateManager = world.func_184163_y();
        Path path = templateManager.func_209509_a(new ResourceLocation("aoa3", StringUtil.toSnakeCase(structureId)), ".nbt");
        Path parentPath = path.getParent();
        try {
            Files.createDirectories(Files.exists(parentPath, new LinkOption[0]) ? parentPath.toRealPath(new LinkOption[0]) : parentPath, new FileAttribute[0]);
            try (FileOutputStream outStream = new FileOutputStream(path.toFile());){
                CompressedStreamTools.func_74799_a((CompoundNBT)data, (OutputStream)outStream);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to create parent directory: " + parentPath.toAbsolutePath());
        }
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        AoACommand.feedback((CommandSource)context.getSource(), "Structures", "command.aoa.structures.desc", AoACommand.CommandFeedbackType.INFO, new String[0]);
        return 1;
    }

    static {
        CMD = new StructureCommand();
    }

    private static class StructureIdArgument
    implements ArgumentType<ResourceLocation> {
        private static final Collection<String> EXAMPLES = Arrays.asList("minecraft:bastion/starts", "aoa3:nether/nethengeic_pit/main_pool");
        private static final DynamicCommandExceptionType UNKNOWN_STRUCTURE_EXCEPTION = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("command.aoa.structures.invalidStructure", new Object[]{arg}));
        private static MinecraftServer server = null;

        private StructureIdArgument() {
        }

        private static StructureIdArgument instance() {
            return new StructureIdArgument();
        }

        public static ResourceLocation getStructureId(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
            return StructureIdArgument.findStructure((ResourceLocation)context.getArgument(name, ResourceLocation.class));
        }

        private static ResourceLocation findStructure(ResourceLocation path) throws CommandSyntaxException {
            TemplateManager templateManager;
            Template template;
            if (server == null) {
                server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            }
            if ((template = (templateManager = server.func_71218_a(DimensionType.field_223227_a_).func_184163_y()).func_200219_b(path)) == null) {
                throw UNKNOWN_STRUCTURE_EXCEPTION.create((Object)path);
            }
            return path;
        }

        public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
            try {
                return ResourceLocation.func_195826_a((StringReader)reader);
            }
            catch (Exception ex) {
                if (StructuresHandler.getStructure(reader.getString()) != null) {
                    return new ResourceLocation("aoa3", reader.getString());
                }
                throw ex;
            }
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }
}

