/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.WikiSearchPacket;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.StringUtil;

public class WikiCommand
implements Command<CommandSource> {
    private static final WikiCommand CMD = new WikiCommand();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"wiki").executes((Command)CMD);
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"search", (ArgumentType)StringArgumentType.greedyString()).requires(command -> command.func_197034_c(0))).executes(WikiCommand::sendPacket));
        return builder;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleSearchRequest(String search) {
        String baseUrl = "?";
        if (search.equalsIgnoreCase("random")) {
            search = "Special:Random";
        }
        try {
            String testRootUrl = "https://adventofascension.gamepedia.com/" + StringUtil.toTitleCase(URLEncoder.encode(search, "UTF-8").replace("+", " ")).replace(" ", "_");
            baseUrl = "https://adventofascension.gamepedia.com/index.php?search=" + URLEncoder.encode(search, "UTF-8") + "&title=Special:Search&go=Go";
            HttpURLConnection connection = (HttpURLConnection)new URL(testRootUrl).openConnection();
            if (connection.getResponseCode() == 200) {
                baseUrl = testRootUrl;
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            if (((Boolean)AoAConfig.CLIENT.doVerboseDebugging.get()).booleanValue()) {
                e.printStackTrace();
            }
        }
        catch (IOException ex) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a(AoACommand.getCmdPrefix("Wiki").func_150257_a(new TranslationTextComponent("command.aoa.wiki.connectionFail", new Object[0]).func_150255_a(new Style().func_150238_a(AoACommand.CommandFeedbackType.ERROR.getColour()))));
        }
        if (search.equals("Special:Random")) {
            search = "???";
        }
        ITextComponent responseComponent = WikiCommand.getComponentFromKeys("command.aoa.wiki.response", baseUrl, StringUtil.toSentenceCase(search));
        Minecraft.func_71410_x().field_71439_g.func_145747_a(AoACommand.getCmdPrefix("Wiki").func_150257_a((ITextComponent)(responseComponent != null ? responseComponent.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)) : new TranslationTextComponent("command.aoawiki.response", new Object[]{baseUrl}))));
    }

    @Nullable
    private static ITextComponent getComponentFromKeys(String langKey, String url, String pageTitle) {
        return ITextComponent.Serializer.func_150699_a((String)("{\"translate\":\"" + langKey + "\",\"with\":[{\"text\":\"" + pageTitle + "\",\"color\":\"red\",\"underlined\":true,\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + url + "\"}}]}"));
    }

    private static int sendPacket(CommandContext<CommandSource> cmd) throws CommandSyntaxException {
        AoAPackets.messagePlayer((ServerPlayerEntity)((CommandSource)cmd.getSource()).func_197027_g(), new WikiSearchPacket(StringArgumentType.getString(cmd, (String)"search")));
        return 1;
    }

    public int run(CommandContext<CommandSource> context) {
        AoACommand.feedback((CommandSource)context.getSource(), "Wiki", "command.aoa.wiki.desc", AoACommand.CommandFeedbackType.INFO, new String[0]);
        return 1;
    }
}

