/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.container.recipe.UpgradeKitRecipe;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.AoARecipes;

public class DivineStationContainer
extends Container {
    public DivineStationInventory inputs = new DivineStationInventory(this);
    public CraftResultInventory output = new CraftResultInventory();
    private final IWorldPosCallable functionCaller;
    private final PlayerEntity player;

    public DivineStationContainer(int id, PlayerInventory inventory) {
        this(id, inventory, IWorldPosCallable.field_221489_a);
    }

    public DivineStationContainer(int screenId, PlayerInventory plInventory, IWorldPosCallable functionCaller) {
        super((ContainerType)AoAContainers.DIVINE_STATION.get(), screenId);
        this.functionCaller = functionCaller;
        this.player = plInventory.field_70458_d;
        this.func_75146_a((Slot)new CraftingResultSlot(this.player, (CraftingInventory)this.inputs, (IInventory)this.output, 0, 134, 23));
        this.func_75146_a(new Slot((IInventory)this.inputs, 0, 27, 23));
        this.func_75146_a(new Slot((IInventory)this.inputs, 1, 76, 23));
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.func_75146_a(new Slot((IInventory)plInventory, inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 60 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)plInventory, hotbarSlot, 8 + hotbarSlot * 18, 118));
        }
    }

    public void func_75130_a(IInventory inventory) {
        this.functionCaller.func_221486_a((world, pos) -> this.slotChangedCraftingGrid((World)world, this.player, this.inputs, this.output));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return DivineStationContainer.func_216963_a((IWorldPosCallable)this.functionCaller, (PlayerEntity)player, (Block)((Block)AoABlocks.DIVINE_STATION.get()));
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.functionCaller.func_221486_a((world, pos) -> this.func_193327_a(player, (World)world, (IInventory)this.inputs));
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.output && super.func_94530_a(stack, slot);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index == 0) {
                this.functionCaller.func_221486_a((world, pos) -> slotStack.func_77973_b().func_77622_d(slotStack, player.field_70170_p, player));
                if (!this.func_75135_a(slotStack, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotStack, stack);
            } else if (index > 2 ? index < 39 && !this.func_75135_a(slotStack, 1, 3, false) : !this.func_75135_a(slotStack, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            if (index == 0) {
                player.func_71019_a(slot.func_190901_a(player, slotStack), false);
            }
        }
        return stack;
    }

    protected void slotChangedCraftingGrid(World world, PlayerEntity player, DivineStationInventory inv, CraftResultInventory craftResult) {
        if (!world.field_72995_K) {
            UpgradeKitRecipe recipe;
            ItemStack resultStack = ItemStack.field_190927_a;
            Optional recipeMatch = world.func_73046_m().func_199529_aN().func_215371_a((IRecipeType)AoARecipes.UPGRADE_KIT.func_76341_a(), (IInventory)inv, world);
            if (recipeMatch.isPresent() && ((recipe = (UpgradeKitRecipe)recipeMatch.get()).func_192399_d() || !world.func_82736_K().func_223586_b(GameRules.field_223618_u) || ((ServerPlayerEntity)player).func_192037_E().func_193830_f((IRecipe)recipe))) {
                craftResult.func_193056_a((IRecipe)recipe);
                resultStack = recipe.getCraftingResult(inv);
            }
            craftResult.func_70299_a(0, resultStack);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, resultStack));
        }
    }

    public static void openContainer(ServerPlayerEntity player, final BlockPos pos) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("container.aoa3.divine_station", new Object[0]);
            }

            @Nullable
            public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                return new DivineStationContainer(windowId, inv, IWorldPosCallable.func_221488_a((World)player.field_70170_p, (BlockPos)pos));
            }
        }, (BlockPos)pos);
    }

    public static class DivineStationInventory
    extends CraftingInventory {
        private final NonNullList<ItemStack> stackList = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        private final Container eventListener;

        public DivineStationInventory(Container container) {
            super(container, 0, 0);
            this.eventListener = container;
        }

        public int func_70302_i_() {
            return 2;
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stackList) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= this.func_70302_i_() || index < 0 ? ItemStack.field_190927_a : (ItemStack)this.stackList.get(index);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stackList, (int)index);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack stack = ItemStackHelper.func_188382_a(this.stackList, (int)index, (int)count);
            if (!stack.func_190926_b()) {
                this.eventListener.func_75130_a((IInventory)this);
            }
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stackList.set(index, (Object)stack);
            this.eventListener.func_75130_a((IInventory)this);
        }

        public void func_174888_l() {
            this.stackList.clear();
        }

        public void func_194018_a(RecipeItemHelper recipeItemHelper) {
            for (ItemStack stack : this.stackList) {
                recipeItemHelper.func_194112_a(stack);
            }
        }
    }
}

