/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.container.recipe.InfusionRecipe;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerUtil;

public class InfusionTableContainer
extends Container {
    private final InfusionInventory inputs = new InfusionInventory(this);
    private final CraftResultInventory output = new CraftResultInventory();
    private final IWorldPosCallable functionCaller;
    private final PlayerEntity player;

    public InfusionTableContainer(int id, PlayerInventory plInventory, IWorldPosCallable functionCaller) {
        super((ContainerType)AoAContainers.INFUSION_TABLE.get(), id);
        this.functionCaller = functionCaller;
        this.player = plInventory.field_70458_d;
        this.func_75146_a(new SlotCraftingMod(this.player, this.inputs, this.output, 0, 139, 35){

            @Override
            protected void func_75208_c(ItemStack stack) {
                InfusionRecipe recipe;
                if (!((InfusionTableContainer)InfusionTableContainer.this).player.field_70170_p.field_72995_K && (recipe = (InfusionRecipe)((CraftResultInventory)this.field_75224_c).func_193055_i()) != null && recipe.getMaxXp() > 0) {
                    if (recipe.getMinXp() == recipe.getMaxXp()) {
                        InfusionTableContainer.this.applyRecipeXp((ServerPlayerEntity)InfusionTableContainer.this.player, recipe.getMinXp());
                    } else {
                        InfusionTableContainer.this.applyRecipeXp((ServerPlayerEntity)InfusionTableContainer.this.player, recipe.getMinXp() + InfusionTableContainer.this.player.func_70681_au().nextInt(recipe.getMaxXp() - recipe.getMinXp()));
                    }
                }
                super.func_75208_c(stack);
            }
        });
        this.func_75146_a(new Slot((IInventory)this.inputs, 0, 17, 35));
        for (int matrixY = 0; matrixY < 3; ++matrixY) {
            for (int matrixX = 0; matrixX < 3; ++matrixX) {
                this.func_75146_a(new Slot((IInventory)this.inputs, 1 + matrixX + matrixY * 3, 45 + matrixX * 18, 17 + matrixY * 18));
            }
        }
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.func_75146_a(new Slot((IInventory)plInventory, inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 84 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)plInventory, hotbarSlot, 8 + hotbarSlot * 18, 142));
        }
    }

    public void func_75130_a(IInventory inventory) {
        this.functionCaller.func_221486_a((world, pos) -> this.slotChangedCraftingGrid((World)world, this.player, this.inputs, this.output));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return InfusionTableContainer.func_216963_a((IWorldPosCallable)this.functionCaller, (PlayerEntity)player, (Block)((Block)AoABlocks.INFUSION_TABLE.get()));
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.functionCaller.func_221486_a((world, pos) -> this.func_193327_a(player, (World)world, (IInventory)this.inputs));
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.output && super.func_94530_a(stack, slot);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index == 0) {
                this.functionCaller.func_221486_a((world, pos) -> slotStack.func_77973_b().func_77622_d(slotStack, player.field_70170_p, player));
                if (!this.func_75135_a(slotStack, 11, 47, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 11 && index < 38 ? !this.func_75135_a(slotStack, 1, 11, false) && !this.func_75135_a(slotStack, 38, 47, false) : (index >= 38 && index < 47 ? !this.func_75135_a(slotStack, 1, 11, false) && !this.func_75135_a(slotStack, 11, 38, false) : !this.func_75135_a(slotStack, 11, 47, false))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            if (index == 0) {
                player.func_71019_a(slot.func_190901_a(player, slotStack), false);
            }
        }
        return stack;
    }

    public static void openContainer(ServerPlayerEntity player, final BlockPos pos) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("container.aoa3.infusion_table", new Object[0]);
            }

            @Nullable
            public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                return new InfusionTableContainer(windowId, inv, IWorldPosCallable.func_221488_a((World)player.field_70170_p, (BlockPos)pos));
            }
        }, (BlockPos)pos);
    }

    protected void slotChangedCraftingGrid(World world, PlayerEntity player, InfusionInventory inv, CraftResultInventory craftResult) {
        if (!world.field_72995_K) {
            InfusionRecipe matchedRecipe;
            ItemStack resultStack = ItemStack.field_190927_a;
            Optional recipeMatch = world.func_73046_m().func_199529_aN().func_215371_a((IRecipeType)AoARecipes.INFUSION.func_76341_a(), (IInventory)inv, world);
            if (recipeMatch.isPresent() && ((matchedRecipe = (InfusionRecipe)recipeMatch.get()).func_192399_d() || !world.func_82736_K().func_223586_b(GameRules.field_223618_u) || ((ServerPlayerEntity)player).func_192037_E().func_193830_f((IRecipe)matchedRecipe)) && (player.func_184812_l_() || PlayerUtil.doesPlayerHaveLevel((ServerPlayerEntity)player, Skills.INFUSION, matchedRecipe.getInfusionReq()))) {
                craftResult.func_193056_a((IRecipe)matchedRecipe);
                resultStack = matchedRecipe.getCraftingResult(inv);
            }
            craftResult.func_70299_a(0, resultStack);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, resultStack));
        }
    }

    private void applyRecipeXp(ServerPlayerEntity player, float xp) {
        PlayerUtil.giveXpToPlayer(player, Skills.INFUSION, xp);
    }

    public static class SlotCraftingMod
    extends Slot {
        private final InfusionInventory craftInv;
        private final PlayerEntity player;
        private int amountCrafted;

        public SlotCraftingMod(PlayerEntity pl, InfusionInventory craftInv, CraftResultInventory inv, int slotIndex, int xPos, int yPos) {
            super((IInventory)inv, slotIndex, xPos, yPos);
            this.player = pl;
            this.craftInv = craftInv;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75209_a(int amount) {
            if (this.func_75216_d()) {
                this.amountCrafted += Math.min(amount, this.func_75211_c().func_190916_E());
            }
            return super.func_75209_a(amount);
        }

        protected void func_75210_a(ItemStack stack, int amount) {
            this.amountCrafted += amount;
            this.func_75208_c(stack);
        }

        protected void func_190900_b(int amount) {
            this.amountCrafted += amount;
        }

        protected void func_75208_c(ItemStack stack) {
            if (this.amountCrafted > 0) {
                stack.func_77980_a(this.player.field_70170_p, this.player, this.amountCrafted);
                BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)this.player, (ItemStack)stack, (IInventory)this.craftInv);
            }
            this.amountCrafted = 0;
            ((CraftResultInventory)this.field_75224_c).func_193056_a(null);
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            this.func_75208_c(stack);
            ForgeHooks.setCraftingPlayer((PlayerEntity)player);
            NonNullList remainingItems = player.field_70170_p.func_199532_z().func_215369_c((IRecipeType)AoARecipes.INFUSION.func_76341_a(), (IInventory)this.craftInv, player.field_70170_p);
            ForgeHooks.setCraftingPlayer(null);
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack slotStack = this.craftInv.func_70301_a(i);
                ItemStack remainingItem = (ItemStack)remainingItems.get(i);
                if (!slotStack.func_190926_b()) {
                    this.craftInv.func_70298_a(i, 1);
                    slotStack = this.craftInv.func_70301_a(i);
                }
                if (remainingItem.func_190926_b()) continue;
                if (slotStack.func_190926_b()) {
                    this.craftInv.func_70299_a(i, remainingItem);
                    continue;
                }
                if (ItemStack.func_179545_c((ItemStack)slotStack, (ItemStack)remainingItem) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)remainingItem)) {
                    remainingItem.func_190917_f(slotStack.func_190916_E());
                    this.craftInv.func_70299_a(i, remainingItem);
                    continue;
                }
                if (player.field_71071_by.func_70441_a(remainingItem)) continue;
                player.func_71019_a(remainingItem, false);
            }
            return stack;
        }
    }

    public static class InfusionInventory
    extends CraftingInventory {
        private final NonNullList<ItemStack> stackList = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
        private final Container eventListener;

        public InfusionInventory(Container eventHandler) {
            super(eventHandler, 0, 0);
            this.eventListener = eventHandler;
        }

        public int func_70302_i_() {
            return 10;
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stackList) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= this.func_70302_i_() || index < 0 ? ItemStack.field_190927_a : (ItemStack)this.stackList.get(index);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stackList, (int)index);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack stack = ItemStackHelper.func_188382_a(this.stackList, (int)index, (int)count);
            if (!stack.func_190926_b()) {
                this.eventListener.func_75130_a((IInventory)this);
            }
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stackList.set(index, (Object)stack);
            this.eventListener.func_75130_a((IInventory)this);
        }

        public void func_174888_l() {
            this.stackList.clear();
        }

        public void func_194018_a(RecipeItemHelper recipeItemHelper) {
            for (ItemStack stack : this.stackList) {
                recipeItemHelper.func_194112_a(stack);
            }
        }
    }
}

