/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.container.UtilityBlockContainer;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.AoAItems;

public class MendingTableContainer
extends UtilityBlockContainer {
    private int totalMaterialCost = 0;

    public MendingTableContainer(int screenId, PlayerInventory plInventory, IWorldPosCallable functionCaller) {
        super((ContainerType)AoAContainers.MENDING_TABLE.get(), screenId, plInventory, functionCaller);
    }

    @Override
    protected Slot initFirstInputSlot() {
        return new Slot((IInventory)this.inputs, 0, 27, 23){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77984_f();
            }
        };
    }

    @Override
    protected Slot initOutputSlot() {
        return new Slot((IInventory)this.output, 2, 134, 23){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                return this.func_75216_d();
            }

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                if (MendingTableContainer.this.totalMaterialCost > 0) {
                    ItemStack repairMaterialStack = MendingTableContainer.this.inputs.func_70301_a(1);
                    if (!repairMaterialStack.func_190926_b() && repairMaterialStack.func_190916_E() >= MendingTableContainer.this.totalMaterialCost) {
                        repairMaterialStack.func_190918_g(MendingTableContainer.this.totalMaterialCost);
                    } else {
                        MendingTableContainer.this.inputs.func_70299_a(1, ItemStack.field_190927_a);
                    }
                } else {
                    MendingTableContainer.this.inputs.func_70299_a(1, ItemStack.field_190927_a);
                }
                MendingTableContainer.this.inputs.func_70299_a(0, ItemStack.field_190927_a);
                return stack;
            }
        };
    }

    @Override
    public void updateOutput() {
        ItemStack repairStack = this.inputs.func_70301_a(0);
        if (repairStack.func_190926_b() || !repairStack.func_77984_f()) {
            this.resetMendingContainerState();
        } else {
            ItemStack repairMaterial = this.inputs.func_70301_a(1);
            if (repairMaterial.func_190926_b()) {
                this.resetMendingContainerState();
            } else {
                ItemStack repairedStack = repairStack.func_77946_l();
                if (repairMaterial.func_77973_b() == AoAItems.MAGIC_REPAIR_DUST.get() || repairMaterial.func_77973_b() == AoAItems.MAGIC_MENDING_COMPOUND.get()) {
                    int repairPortionValue;
                    int n = repairPortionValue = repairMaterial.func_77973_b() == AoAItems.MAGIC_MENDING_COMPOUND.get() ? repairedStack.func_77952_i() : Math.min(repairedStack.func_77952_i(), repairedStack.func_77958_k() / 5);
                    if (repairPortionValue <= 0) {
                        this.resetMendingContainerState();
                    } else {
                        int repairCount;
                        for (repairCount = 0; repairPortionValue > 0 && repairCount < repairMaterial.func_190916_E(); ++repairCount) {
                            repairedStack.func_196085_b(repairedStack.func_77952_i() - repairPortionValue);
                            repairPortionValue = Math.min(repairedStack.func_77952_i(), repairedStack.func_77958_k() / 5);
                        }
                        this.totalMaterialCost = repairCount;
                        this.output.func_70299_a(0, repairedStack);
                    }
                }
            }
        }
    }

    private void resetMendingContainerState() {
        this.output.func_70299_a(0, ItemStack.field_190927_a);
        this.totalMaterialCost = 0;
    }

    @Override
    protected Block getBlock() {
        return (Block)AoABlocks.MENDING_TABLE.get();
    }

    public static void openContainer(ServerPlayerEntity player, final BlockPos pos) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("container.aoa3.mending_table", new Object[0]);
            }

            @Nullable
            public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                return new MendingTableContainer(windowId, inv, IWorldPosCallable.func_221488_a((World)player.field_70170_p, (BlockPos)pos));
            }
        }, (BlockPos)pos);
    }
}

