/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tslat.aoa3.common.container.InfusionTableContainer;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.LocaleUtil;

public class InfusionRecipe
implements IRecipe<InfusionTableContainer.InfusionInventory> {
    private static final InfusionRecipe EMPTY_RECIPE = new InfusionRecipe(new ResourceLocation("aoa3", "infusion_empty"), "", ItemStack.field_190927_a, ItemStack.field_190927_a, (NonNullList<Ingredient>)NonNullList.func_191196_a(), 1, 0, 0);
    private final ResourceLocation id;
    private final String group;
    private final ItemStack output;
    private final ItemStack input;
    protected final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;
    private final int minXp;
    private final int maxXp;
    private final boolean isEnchanting;
    private final Enchantment enchantment;
    private final int enchantmentLevel;
    private final int infusionReq;

    public InfusionRecipe(ResourceLocation id, String group, ItemStack output, ItemStack input, NonNullList<Ingredient> ingredients, int infusionLevelReq, int minXp, int maxXp) {
        this.id = id;
        this.isEnchanting = false;
        this.output = output;
        this.input = input;
        this.ingredients = ingredients;
        this.group = group;
        this.infusionReq = MathHelper.func_76125_a((int)infusionLevelReq, (int)1, (int)1000);
        boolean simple = true;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isSimple()) continue;
            simple = false;
            break;
        }
        this.isSimple = simple;
        this.enchantment = null;
        this.enchantmentLevel = -1;
        this.minXp = minXp;
        this.maxXp = maxXp;
    }

    public InfusionRecipe(ResourceLocation id, String group, Enchantment enchantment, int level, NonNullList<Ingredient> ingredients, int infusionLevelReq, int minXp, int maxXp) {
        this.id = id;
        this.isEnchanting = true;
        this.group = group;
        this.enchantment = enchantment;
        this.ingredients = ingredients;
        this.enchantmentLevel = level;
        this.infusionReq = MathHelper.func_76125_a((int)infusionLevelReq, (int)1, (int)1000);
        boolean simple = true;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isSimple()) continue;
            simple = false;
            break;
        }
        this.isSimple = simple;
        this.output = ItemStack.field_190927_a;
        this.input = ItemStack.field_190927_a;
        this.minXp = minXp;
        this.maxXp = maxXp;
    }

    public boolean matches(InfusionTableContainer.InfusionInventory inv, World world) {
        if (this != EMPTY_RECIPE) {
            int ingredientCount = 0;
            RecipeItemHelper recipeItemHelper = new RecipeItemHelper();
            ArrayList<ItemStack> inputIngredients = new ArrayList<ItemStack>();
            ItemStack inputStack = inv.func_70301_a(0);
            if (inputStack.func_190926_b() || !this.isEnchanting && this.input.func_77973_b() != inputStack.func_77973_b()) {
                return false;
            }
            for (int i = 1; i < 10; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                ++ingredientCount;
                if (this.isSimple) {
                    recipeItemHelper.func_221264_a(stack, 1);
                    continue;
                }
                inputIngredients.add(stack);
            }
            if (ingredientCount != this.ingredients.size()) {
                return false;
            }
            if (this.isEnchanting && EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)inputStack) >= this.enchantmentLevel) {
                return false;
            }
            if (this.isSimple) {
                return recipeItemHelper.func_194116_a((IRecipe)this, null);
            }
            return RecipeMatcher.findMatches(inputIngredients, this.ingredients) != null;
        }
        return false;
    }

    public ItemStack getCraftingResult(InfusionTableContainer.InfusionInventory inv) {
        if (this.isEnchanting) {
            return this.provideEmptyOrCompatibleStackForEnchanting(inv.func_70301_a(0).func_77946_l());
        }
        return this.output.func_77946_l();
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)AoABlocks.INFUSION_TABLE.get());
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public ItemStack func_77571_b() {
        return this.isEnchanting ? ItemStack.field_190927_a : this.output;
    }

    public ItemStack getRecipeInput() {
        return this.input;
    }

    public boolean isEnchanting() {
        return this.isEnchanting;
    }

    public int getInfusionReq() {
        return this.infusionReq;
    }

    public int getMinXp() {
        return this.minXp;
    }

    public int getMaxXp() {
        return this.maxXp;
    }

    @Nullable
    public EnchantmentData getEnchantment() {
        if (this.enchantment == null) {
            return null;
        }
        return new EnchantmentData(this.enchantment, this.enchantmentLevel);
    }

    public ItemStack getEnchantmentAsBook() {
        if (!this.isEnchanting || this == EMPTY_RECIPE) {
            return ItemStack.field_190927_a;
        }
        ItemStack bookStack = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantedBookItem.func_92115_a((ItemStack)bookStack, (EnchantmentData)new EnchantmentData(this.enchantment, this.enchantmentLevel));
        return bookStack;
    }

    public NonNullList<ItemStack> getRemainingItems(InfusionTableContainer.InfusionInventory inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        remainingItems.set(0, (Object)ItemStack.field_190927_a);
        for (int i = 1; i < remainingItems.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return remainingItems;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public String func_193358_e() {
        return this.group;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)((RegistryObject)AoARecipes.INFUSION.func_76340_b()).get();
    }

    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)AoARecipes.INFUSION.func_76341_a();
    }

    public ItemStack provideEmptyOrCompatibleStackForEnchanting(ItemStack inputStack) {
        if (this == EMPTY_RECIPE || !this.enchantment.func_92089_a(inputStack) || !((Boolean)AoAConfig.SERVER.allowUnsafeInfusion.get()).booleanValue() && this.enchantment.func_77325_b() < this.enchantmentLevel) {
            return ItemStack.field_190927_a;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)inputStack);
        for (Enchantment enchantment : enchantments.keySet()) {
            if (this.enchantment == enchantment || enchantment.func_191560_c(this.enchantment) && this.enchantment.func_191560_c(enchantment)) continue;
            return ItemStack.field_190927_a;
        }
        enchantments.put(this.enchantment, this.enchantmentLevel);
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)inputStack);
        return inputStack;
    }

    public static class Factory
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfusionRecipe> {
        public InfusionRecipe read(ResourceLocation recipeId, JsonObject json) {
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"infusion")) {
                String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
                int level = 1;
                int infusionReq = 1;
                int minXp = 0;
                int maxXp = 0;
                NonNullList ingredients = NonNullList.func_191196_a();
                JsonObject enchantmentJson = JSONUtils.func_152754_s((JsonObject)json, (String)"infusion");
                if (!enchantmentJson.has("enchantment")) {
                    throw new JsonParseException("No valid enchantment for Infusion recipe");
                }
                String enchantmentString = JSONUtils.func_151200_h((JsonObject)enchantmentJson, (String)"enchantment");
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentString));
                if (json.has("infusion_level")) {
                    infusionReq = JSONUtils.func_151203_m((JsonObject)json, (String)"infusion_level");
                }
                if (json.has("infusion_xp")) {
                    JsonObject xpJson = JSONUtils.func_152754_s((JsonObject)json, (String)"infusion_xp");
                    if (xpJson.isJsonPrimitive()) {
                        minXp = maxXp = xpJson.getAsInt();
                    } else if (xpJson.has("min")) {
                        if (!xpJson.has("max")) {
                            throw new JsonParseException("No max set for min/max xp amount for infusion recipe");
                        }
                        minXp = Math.max(0, JSONUtils.func_151203_m((JsonObject)xpJson, (String)"min"));
                        maxXp = Math.max(minXp, JSONUtils.func_151203_m((JsonObject)xpJson, (String)"max"));
                    }
                }
                if (enchantment == null) {
                    throw new JsonParseException("Invalid enchantment for infusion recipe: " + enchantmentString);
                }
                if (enchantmentJson.has("level")) {
                    level = JSONUtils.func_151203_m((JsonObject)enchantmentJson, (String)"level");
                }
                if (!((Boolean)AoAConfig.SERVER.allowUnsafeInfusion.get()).booleanValue() && enchantment.func_77325_b() < level) {
                    throw new JsonParseException("Unsafe enchantment level for recipe, Enchantment: " + LocaleUtil.getLocaleString(enchantment.func_77320_a()) + ", Lvl: " + level + ", and Allow Unsafe Infusion not enabled in config");
                }
                for (JsonElement element : JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                    try {
                        ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element));
                    }
                    catch (JsonSyntaxException ex) {
                        if (ex.getMessage().startsWith("Unknown item") && !ModList.get().isLoaded(ex.getMessage().split("'")[1].split(":")[0])) {
                            return EMPTY_RECIPE;
                        }
                        throw ex;
                    }
                }
                if (ingredients.isEmpty()) {
                    throw new JsonParseException("No ingredients for infusion table recipe");
                }
                if (ingredients.size() > 9) {
                    throw new JsonParseException("Too many ingredients for infusion table recipe");
                }
                return new InfusionRecipe(recipeId, group, enchantment, level, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
            }
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ItemStack input = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"input"), (boolean)false);
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            NonNullList ingredients = NonNullList.func_191196_a();
            int infusionReq = 1;
            int minXp = 0;
            int maxXp = 0;
            if (json.has("infusion_level")) {
                infusionReq = JSONUtils.func_151203_m((JsonObject)json, (String)"infusion_level");
            }
            if (json.has("infusion_xp")) {
                JsonObject xpJson = JSONUtils.func_152754_s((JsonObject)json, (String)"infusion_xp");
                if (xpJson.isJsonPrimitive()) {
                    minXp = maxXp = xpJson.getAsInt();
                } else if (xpJson.has("min")) {
                    if (!xpJson.has("max")) {
                        throw new JsonParseException("No max set for min/max xp amount for infusion recipe");
                    }
                    minXp = Math.max(0, JSONUtils.func_151203_m((JsonObject)xpJson, (String)"min"));
                    maxXp = Math.max(minXp, JSONUtils.func_151203_m((JsonObject)xpJson, (String)"max"));
                }
            }
            for (JsonElement element : JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for infusion table recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for infusion table recipe");
            }
            return new InfusionRecipe(recipeId, group, output, input, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
        }

        @Nullable
        public InfusionRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            if (buffer.readBoolean()) {
                Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.func_192575_l());
                int lvl = buffer.readInt();
                NonNullList ingredients = NonNullList.func_191197_a((int)buffer.readInt(), (Object)Ingredient.field_193370_a);
                for (int i = 0; i < ingredients.size(); ++i) {
                    ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
                }
                int infusionReq = buffer.readInt();
                int minXp = buffer.readInt();
                int maxXp = buffer.readInt();
                return new InfusionRecipe(recipeId, group, ench, lvl, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
            }
            ItemStack input = buffer.func_150791_c();
            ItemStack output = buffer.func_150791_c();
            NonNullList ingredients = NonNullList.func_191197_a((int)buffer.readInt(), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            int infusionReq = buffer.readInt();
            int minXp = buffer.readInt();
            int maxXp = buffer.readInt();
            return new InfusionRecipe(recipeId, group, output, input, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
        }

        public void write(PacketBuffer buffer, InfusionRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            if (recipe.isEnchanting()) {
                buffer.writeBoolean(true);
                buffer.func_192572_a(recipe.getEnchantment().field_76302_b.getRegistryName());
                buffer.writeInt(recipe.getEnchantment().field_76303_c);
                buffer.writeInt(recipe.func_192400_c().size());
                for (Ingredient ing : recipe.func_192400_c()) {
                    ing.func_199564_a(buffer);
                }
            } else {
                buffer.writeBoolean(false);
                buffer.writeItemStack(recipe.getRecipeInput(), true);
                buffer.writeItemStack(recipe.func_77571_b(), false);
                buffer.writeInt(recipe.func_192400_c().size());
                for (Ingredient ing : recipe.func_192400_c()) {
                    ing.func_199564_a(buffer);
                }
            }
            buffer.writeInt(recipe.getInfusionReq());
            buffer.writeInt(recipe.getMinXp());
            buffer.writeInt(recipe.getMaxXp());
        }
    }
}

