/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tslat.aoa3.block.functional.misc.TrophyBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoARecipes;

public class TrophyRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    public static final ResourceLocation ID = new ResourceLocation("aoa3", "trophy");
    private final String group;

    public TrophyRecipe(String group) {
        this.group = group;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        for (int x = 0; x <= inv.func_174922_i() - 3; ++x) {
            for (int y = 0; y <= inv.func_174923_h() - 3; ++y) {
                if (!this.checkMatch(inv)) continue;
                return true;
            }
        }
        return false;
    }

    public String func_193358_e() {
        return this.group;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_77973_b() != ((Block)AoABlocks.TROPHY.get()).func_199767_j()) continue;
            return TrophyBlock.cloneTrophy(inv.func_70301_a(i), (IItemProvider)AoABlocks.GOLD_TROPHY.get());
        }
        return ItemStack.field_190927_a;
    }

    private boolean checkMatch(CraftingInventory inv) {
        String entityType = null;
        for (int gridX = 0; gridX < inv.func_174922_i(); ++gridX) {
            for (int gridY = 0; gridY < inv.func_174923_h(); ++gridY) {
                ItemStack slotStack = inv.func_70301_a(gridX + gridY * inv.func_174922_i());
                if (slotStack.func_77973_b() != ((Block)AoABlocks.TROPHY.get()).func_199767_j() || !slotStack.func_77942_o()) {
                    return false;
                }
                CompoundNBT tag = slotStack.func_77978_p();
                if (!tag.func_74764_b("BlockEntityTag")) {
                    return false;
                }
                CompoundNBT blockEntityTag = tag.func_74775_l("BlockEntityTag");
                if (!blockEntityTag.func_74764_b("OriginalTrophy") || !blockEntityTag.func_74767_n("OriginalTrophy")) {
                    return false;
                }
                if (!blockEntityTag.func_74764_b("EntityID")) continue;
                if (entityType == null) {
                    entityType = blockEntityTag.func_74779_i("EntityID");
                    continue;
                }
                if (entityType.equals(blockEntityTag.func_74779_i("EntityID"))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)AoABlocks.GOLD_TROPHY.get());
    }

    public ResourceLocation func_199560_c() {
        return ID;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)((RegistryObject)AoARecipes.TROPHY.func_76340_b()).get();
    }

    public IRecipeType<?> func_222127_g() {
        return IRecipeType.field_222149_a;
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 3;
    }

    public static class Factory
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TrophyRecipe> {
        public TrophyRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new TrophyRecipe(json.has("group") ? JSONUtils.func_151200_h((JsonObject)json, (String)"group") : "");
        }

        @Nullable
        public TrophyRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new TrophyRecipe(buffer.func_150789_c(Short.MAX_VALUE));
        }

        public void write(PacketBuffer buffer, TrophyRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
        }
    }
}

