/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tslat.aoa3.common.container.DivineStationContainer;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoARecipes;

public class UpgradeKitRecipe
implements IRecipe<DivineStationContainer.DivineStationInventory> {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack input;
    private final ItemStack upgradeKit;
    private final ItemStack output;

    public UpgradeKitRecipe(ResourceLocation id, String group, ItemStack input, ItemStack upgradeKit, ItemStack output) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.upgradeKit = upgradeKit;
        this.output = output;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)AoABlocks.DIVINE_STATION.get());
    }

    public boolean matches(DivineStationContainer.DivineStationInventory inv, World world) {
        return ItemStack.func_179545_c((ItemStack)this.input, (ItemStack)inv.func_70301_a(0)) && ItemStack.func_179545_c((ItemStack)this.upgradeKit, (ItemStack)inv.func_70301_a(1));
    }

    public ItemStack getCraftingResult(DivineStationContainer.DivineStationInventory inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height <= 3;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<UpgradeKitRecipe> func_199559_b() {
        return (IRecipeSerializer)((RegistryObject)AoARecipes.UPGRADE_KIT.func_76340_b()).get();
    }

    public IRecipeType<UpgradeKitRecipe> func_222127_g() {
        return (IRecipeType)AoARecipes.UPGRADE_KIT.func_76341_a();
    }

    public NonNullList<ItemStack> getRemainingItems(DivineStationContainer.DivineStationInventory inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return remainingItems;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.input}));
        ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.upgradeKit}));
        return ingredients;
    }

    public String func_193358_e() {
        return this.group;
    }

    public static class Factory
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<UpgradeKitRecipe> {
        public UpgradeKitRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ItemStack inputItem = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"input"), (boolean)false);
            ItemStack upgradeKit = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"upgrade_kit"), (boolean)false);
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new UpgradeKitRecipe(recipeId, group, inputItem, upgradeKit, output);
        }

        @Nullable
        public UpgradeKitRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            ItemStack inputItem = buffer.func_150791_c();
            ItemStack upgradeKit = buffer.func_150791_c();
            ItemStack output = buffer.func_150791_c();
            return new UpgradeKitRecipe(recipeId, group, inputItem, upgradeKit, output);
        }

        public void write(PacketBuffer buffer, UpgradeKitRecipe recipe) {
            buffer.func_211400_a(recipe.func_193358_e(), Short.MAX_VALUE);
            buffer.func_150788_a(recipe.input);
            buffer.func_150788_a(recipe.upgradeKit);
            buffer.func_150788_a(recipe.output);
        }
    }
}

