/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.util.ClientOperations;

public class GunRecoilPacket
implements AoAPacket {
    private final float recoilAmount;
    private final int firingTime;

    public GunRecoilPacket(float recoil, int firingDelay) {
        this.recoilAmount = recoil;
        this.firingTime = firingDelay;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeFloat(this.recoilAmount);
        buffer.writeInt(this.firingTime);
    }

    public static GunRecoilPacket decode(PacketBuffer buffer) {
        return new GunRecoilPacket(buffer.readFloat(), buffer.readInt());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        ClientOperations.addRecoil(this.recoilAmount, this.firingTime);
        context.get().setPacketHandled(true);
    }
}

