/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.library.misc.AoAHalos;
import org.apache.logging.log4j.Level;

public class HaloChangePacket
implements AoAPacket {
    private final String haloChoice;

    public HaloChangePacket(@Nonnull AoAHalos.Type.Choosable haloChoice) {
        this.haloChoice = haloChoice.toString();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.haloChoice);
    }

    public static HaloChangePacket decode(PacketBuffer buffer) {
        return new HaloChangePacket(AoAHalos.Type.Choosable.valueOf(buffer.func_150789_c(Short.MAX_VALUE)));
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        AoAHalos.Type preferredHalo;
        block4: {
            preferredHalo = AoAHalos.Type.Donator;
            try {
                preferredHalo = AoAHalos.Type.Choosable.valueOf(this.haloChoice).toBaseType();
            }
            catch (IllegalArgumentException e) {
                if (!((Boolean)AoAConfig.COMMON.doVerboseDebugging.get()).booleanValue()) break block4;
                Logging.logMessage(Level.WARN, "Error parsing halo info from client: " + this.haloChoice);
                e.printStackTrace();
            }
        }
        ServerPlayerEntity sender = context.get().getSender();
        if (sender != null) {
            AoAHalos.syncNewHaloChoice(sender.func_146103_bH().getId(), preferredHalo);
        } else {
            Logging.logMessage(Level.WARN, "No sender assigned to received PacketChangedHalo, skipping");
        }
        context.get().setPacketHandled(true);
    }
}

