/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.item.LongReachItem;
import org.apache.logging.log4j.Level;

public class LongReachItemHitPacket
implements AoAPacket {
    private final int entityId;

    public LongReachItemHitPacket(int id) {
        this.entityId = id;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
    }

    public static LongReachItemHitPacket decode(PacketBuffer buffer) {
        return new LongReachItemHitPacket(buffer.readInt());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        if (player == null) {
            Logging.logMessage(Level.ERROR, "Received a long reach item hit packet with no assigned player, how does this even happen forge? C'mon bro.");
            return;
        }
        player.func_71128_l();
        if (player.field_71069_bz == null || player.field_71070_bA instanceof PlayerContainer) {
            context.get().enqueueWork(() -> {
                ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
                if (!(stack.func_77973_b() instanceof LongReachItem)) {
                    Logging.logMessage(Level.WARN, "Received long reach item packet but player is not holding a long reach item.");
                    return;
                }
                Entity target = player.field_70170_p.func_73045_a(this.entityId);
                if (target == null) {
                    Logging.logMessage(Level.WARN, "No entity found for long reach item packet, skipping");
                    return;
                }
                LongReachItem weapon = (LongReachItem)stack.func_77973_b();
                if (!player.func_184587_cr()) {
                    double reach = weapon.getReach();
                    if (player.func_70068_e(target) < reach * reach) {
                        RayTraceContext traceContext = new RayTraceContext(new Vec3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_()), new Vec3d(target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null);
                        BlockRayTraceResult rayTrace = player.field_70170_p.func_217299_a(traceContext);
                        BlockPos pos = new BlockPos(rayTrace.func_216347_e());
                        if (rayTrace.func_216346_c() == RayTraceResult.Type.MISS || rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK && !player.field_70170_p.func_180495_p(pos).func_200015_d((IBlockReader)player.field_70170_p, pos)) {
                            weapon.hitEntity(stack, target, (LivingEntity)player, -1.0f);
                        }
                    }
                }
            });
        }
        context.get().setPacketHandled(true);
    }
}

