/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.aoa3.client.MusicPlayer;
import net.tslat.aoa3.common.packet.packets.AoAPacket;

public class MusicPacket
implements AoAPacket {
    private final boolean startingMusic;
    private final ResourceLocation id;

    public MusicPacket(boolean startingMusic, ResourceLocation id) {
        this.startingMusic = startingMusic;
        this.id = id;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.startingMusic);
        buffer.func_180714_a(this.id.toString());
    }

    public static MusicPacket decode(PacketBuffer buffer) {
        return new MusicPacket(buffer.readBoolean(), new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        if (this.startingMusic) {
            MusicPlayer.playMusic(this.id);
        } else {
            MusicPlayer.stopMusic(this.id);
        }
        context.get().setPacketHandled(true);
    }
}

