/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.client.gui.hud.ResourcesRenderer;
import net.tslat.aoa3.common.packet.packets.AoAPacket;

public class ResourceDataPacket
implements AoAPacket {
    private final float creation;
    private final float energy;
    private final float rage;
    private final float soul;
    private final boolean revengeActive;

    public ResourceDataPacket(float creation, float energy, float rage, float soul, boolean revengeActive) {
        this.creation = creation;
        this.energy = energy;
        this.rage = rage;
        this.soul = soul;
        this.revengeActive = revengeActive;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeFloat(this.creation);
        buffer.writeFloat(this.energy);
        buffer.writeFloat(this.rage);
        buffer.writeFloat(this.soul);
        buffer.writeBoolean(this.revengeActive);
    }

    public static ResourceDataPacket decode(PacketBuffer buffer) {
        return new ResourceDataPacket(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        AdventGuiTabPlayer.resourceCreation = this.creation;
        AdventGuiTabPlayer.resourceEnergy = this.energy;
        AdventGuiTabPlayer.resourceRage = this.rage;
        AdventGuiTabPlayer.resourceSoul = this.soul;
        ResourcesRenderer.revengeActive = this.revengeActive;
        context.get().setPacketHandled(true);
    }
}

