/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.util.constant.Skills;
import org.apache.logging.log4j.Level;

public class SkillDataPacket
implements AoAPacket {
    private final int skillId;
    private final int level;
    private final float xp;
    private final int data;

    public SkillDataPacket(int skill, int lvl, float xp, Integer opt) {
        this.skillId = skill;
        this.level = lvl;
        this.xp = xp;
        if (opt == null) {
            opt = 0;
        }
        this.data = opt;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.skillId);
        buffer.writeInt(this.level);
        buffer.writeFloat(this.xp);
        buffer.writeInt(this.data);
    }

    public static SkillDataPacket decode(PacketBuffer buffer) {
        return new SkillDataPacket(buffer.readInt(), buffer.readInt(), buffer.readFloat(), buffer.readInt());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        Skills skill = Skills.getById(this.skillId);
        if (skill != null) {
            AdventGuiTabPlayer.setSkillData(skill, this.xp, this.level, this.data);
        } else {
            Logging.logMessage(Level.WARN, "Error trying to set skill data in client skills holder, skipping");
        }
        context.get().setPacketHandled(true);
    }
}

