/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.util.ClientOperations;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.constant.Skills;

public class ToastPopupPacket
implements AoAPacket {
    private final ToastPopupType type;
    private final Object subject;
    private final Object value;

    public ToastPopupPacket(Skills skill, int levelReq) {
        this.type = ToastPopupType.SKILL_REQUIREMENT;
        this.value = levelReq;
        this.subject = skill;
    }

    public ToastPopupPacket(Resources resource, float amount) {
        this.type = ToastPopupType.RESOURCE_REQUIREMENT;
        this.value = Float.valueOf(amount);
        this.subject = resource;
    }

    public ToastPopupPacket(Deities deity, int tributeAmount) {
        this.type = ToastPopupType.TRIBUTE_REQUIREMENT;
        this.subject = deity;
        this.value = tributeAmount;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.type.toString());
        switch (this.type) {
            case SKILL_REQUIREMENT: 
            case TRIBUTE_REQUIREMENT: {
                buffer.func_180714_a(this.subject.toString());
                buffer.writeInt(((Integer)this.value).intValue());
                break;
            }
            case RESOURCE_REQUIREMENT: {
                buffer.func_180714_a(this.subject.toString());
                buffer.writeFloat(((Float)this.value).floatValue());
            }
        }
    }

    public static ToastPopupPacket decode(PacketBuffer buffer) {
        ToastPopupType type = ToastPopupType.valueOf(buffer.func_150789_c(Short.MAX_VALUE));
        switch (type) {
            case SKILL_REQUIREMENT: {
                return new ToastPopupPacket(Skills.valueOf(buffer.func_150789_c(Short.MAX_VALUE)), buffer.readInt());
            }
            case RESOURCE_REQUIREMENT: {
                return new ToastPopupPacket(Resources.valueOf(buffer.func_150789_c(Short.MAX_VALUE)), buffer.readFloat());
            }
            case TRIBUTE_REQUIREMENT: {
                return new ToastPopupPacket(Deities.valueOf(buffer.func_150789_c(Short.MAX_VALUE)), buffer.readInt());
            }
        }
        return null;
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        ClientOperations.addToast(this.type, this.subject, this.value);
        context.get().setPacketHandled(true);
    }

    public static enum ToastPopupType {
        SKILL_REQUIREMENT,
        RESOURCE_REQUIREMENT,
        TRIBUTE_REQUIREMENT;

    }
}

