/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabPlayer;
import net.tslat.aoa3.client.gui.hud.XpParticlesRenderer;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.constant.Skills;

public class XpGainPacket
implements AoAPacket {
    private final int skillId;
    private final float xp;
    private final boolean levelUp;

    public XpGainPacket(int skill, float xp, boolean isLevelUp) {
        this.skillId = skill;
        this.xp = xp;
        this.levelUp = isLevelUp;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.skillId);
        buffer.writeFloat(this.xp);
        buffer.writeBoolean(this.levelUp);
    }

    public static XpGainPacket decode(PacketBuffer buffer) {
        return new XpGainPacket(buffer.readInt(), buffer.readFloat(), buffer.readBoolean());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        Skills skill;
        if (((Boolean)AoAConfig.CLIENT.showXpParticles.get()).booleanValue() && (AdventGuiTabPlayer.getSkillLevel(skill = Skills.getById(this.skillId)) < 100 || ((Boolean)AoAConfig.CLIENT.showVanityLevels.get()).booleanValue())) {
            XpParticlesRenderer.addXpParticle(skill, this.xp, this.levelUp);
        }
        context.get().setPacketHandled(true);
    }
}

