/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.item.armour.AchelosHelmet;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.item.armour.AlacrityArmour;
import net.tslat.aoa3.item.armour.AlchemyArmour;
import net.tslat.aoa3.item.armour.AmethindArmour;
import net.tslat.aoa3.item.armour.AnimaArmour;
import net.tslat.aoa3.item.armour.ArchaicArmour;
import net.tslat.aoa3.item.armour.AuguryArmour;
import net.tslat.aoa3.item.armour.BaronArmour;
import net.tslat.aoa3.item.armour.BattlebornArmour;
import net.tslat.aoa3.item.armour.BiogenicArmour;
import net.tslat.aoa3.item.armour.BoreicArmour;
import net.tslat.aoa3.item.armour.ButcheryArmour;
import net.tslat.aoa3.item.armour.CandyArmour;
import net.tslat.aoa3.item.armour.CommanderArmour;
import net.tslat.aoa3.item.armour.CreationArmour;
import net.tslat.aoa3.item.armour.CrystallisArmour;
import net.tslat.aoa3.item.armour.ElecanyteArmour;
import net.tslat.aoa3.item.armour.EmbrodiumArmour;
import net.tslat.aoa3.item.armour.EngineeringArmour;
import net.tslat.aoa3.item.armour.ExoplateArmour;
import net.tslat.aoa3.item.armour.ExpeditionArmour;
import net.tslat.aoa3.item.armour.ExplosiveArmour;
import net.tslat.aoa3.item.armour.ExtractionArmour;
import net.tslat.aoa3.item.armour.FaceMask;
import net.tslat.aoa3.item.armour.ForagingArmour;
import net.tslat.aoa3.item.armour.FungalArmour;
import net.tslat.aoa3.item.armour.GhastlyArmour;
import net.tslat.aoa3.item.armour.GhoulishArmour;
import net.tslat.aoa3.item.armour.HaulingArmour;
import net.tslat.aoa3.item.armour.HazmatArmour;
import net.tslat.aoa3.item.armour.HunterArmour;
import net.tslat.aoa3.item.armour.HydrangicArmour;
import net.tslat.aoa3.item.armour.HydroplateArmour;
import net.tslat.aoa3.item.armour.IceArmour;
import net.tslat.aoa3.item.armour.InfernalArmour;
import net.tslat.aoa3.item.armour.InfusionArmour;
import net.tslat.aoa3.item.armour.InnervationArmour;
import net.tslat.aoa3.item.armour.KnightArmour;
import net.tslat.aoa3.item.armour.LoggingArmour;
import net.tslat.aoa3.item.armour.LunarArmour;
import net.tslat.aoa3.item.armour.LyndamyteArmour;
import net.tslat.aoa3.item.armour.LyonicArmour;
import net.tslat.aoa3.item.armour.MercurialArmour;
import net.tslat.aoa3.item.armour.NecroArmour;
import net.tslat.aoa3.item.armour.NethengeicArmour;
import net.tslat.aoa3.item.armour.NightVisionGoggles;
import net.tslat.aoa3.item.armour.NightmareArmour;
import net.tslat.aoa3.item.armour.OceanusHelmet;
import net.tslat.aoa3.item.armour.OmniArmour;
import net.tslat.aoa3.item.armour.PhantasmArmour;
import net.tslat.aoa3.item.armour.PoisonArmour;
import net.tslat.aoa3.item.armour.PredatiousArmour;
import net.tslat.aoa3.item.armour.PrimordialArmour;
import net.tslat.aoa3.item.armour.PurityArmour;
import net.tslat.aoa3.item.armour.RockboneArmour;
import net.tslat.aoa3.item.armour.RosidianArmour;
import net.tslat.aoa3.item.armour.RunationArmour;
import net.tslat.aoa3.item.armour.RunicArmour;
import net.tslat.aoa3.item.armour.SealordHelmet;
import net.tslat.aoa3.item.armour.SharpshotArmour;
import net.tslat.aoa3.item.armour.SkeletalArmour;
import net.tslat.aoa3.item.armour.SpacekingArmour;
import net.tslat.aoa3.item.armour.SpeedArmour;
import net.tslat.aoa3.item.armour.SubterraneanArmour;
import net.tslat.aoa3.item.armour.UtopianArmour;
import net.tslat.aoa3.item.armour.VoidArmour;
import net.tslat.aoa3.item.armour.WeakenArmour;
import net.tslat.aoa3.item.armour.WitherArmour;
import net.tslat.aoa3.item.armour.ZargoniteArmour;
import org.apache.logging.log4j.Level;

public final class AoAArmour {
    public static final DeferredRegister<Item> ARMOUR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"aoa3");
    public static final RegistryObject<Item> ACHELOS_HELMET = AoAArmour.registerArmour("achelos_helmet", AchelosHelmet::new);
    public static final RegistryObject<Item> OCEANUS_HELMET = AoAArmour.registerArmour("oceanus_helmet", OceanusHelmet::new);
    public static final RegistryObject<Item> SEALORD_HELMET = AoAArmour.registerArmour("sealord_helmet", SealordHelmet::new);
    public static final RegistryObject<Item> FACE_MASK = AoAArmour.registerArmour("face_mask", FaceMask::new);
    public static final RegistryObject<Item> NIGHT_VISION_GOGGLES = AoAArmour.registerArmour("night_vision_goggles", NightVisionGoggles::new);
    public static final ArmourSet ALACRITY_ARMOUR = AoAArmour.registerArmourSet("alacrity", AlacrityArmour.class);
    public static final ArmourSet ALCHEMY_ARMOUR = AoAArmour.registerArmourSet("alchemy", AlchemyArmour.class);
    public static final ArmourSet AMETHIND_ARMOUR = AoAArmour.registerArmourSet("amethind", AmethindArmour.class);
    public static final ArmourSet ANIMA_ARMOUR = AoAArmour.registerArmourSet("anima", AnimaArmour.class);
    public static final ArmourSet ARCHAIC_ARMOUR = AoAArmour.registerArmourSet("archaic", ArchaicArmour.class);
    public static final ArmourSet AUGURY_ARMOUR = AoAArmour.registerArmourSet("augury", AuguryArmour.class);
    public static final ArmourSet BARON_ARMOUR = AoAArmour.registerArmourSet("baron", BaronArmour.class);
    public static final ArmourSet BATTLEBORN_ARMOUR = AoAArmour.registerArmourSet("battleborn", BattlebornArmour.class);
    public static final ArmourSet BIOGENIC_ARMOUR = AoAArmour.registerArmourSet("biogenic", BiogenicArmour.class);
    public static final ArmourSet BOREIC_ARMOUR = AoAArmour.registerArmourSet("boreic", BoreicArmour.class);
    public static final ArmourSet BUTCHERY_ARMOUR = AoAArmour.registerArmourSet("butchery", ButcheryArmour.class);
    public static final ArmourSet CANDY_ARMOUR = AoAArmour.registerArmourSet("candy", CandyArmour.class);
    public static final ArmourSet COMMANDER_ARMOUR = AoAArmour.registerArmourSet("commander", CommanderArmour.class);
    public static final ArmourSet CREATION_ARMOUR = AoAArmour.registerArmourSet("creation", CreationArmour.class);
    public static final ArmourSet CRYSTALLIS_ARMOUR = AoAArmour.registerArmourSet("crystallis", CrystallisArmour.class);
    public static final ArmourSet ELECANYTE_ARMOUR = AoAArmour.registerArmourSet("elecanyte", ElecanyteArmour.class);
    public static final ArmourSet EMBRODIUM_ARMOUR = AoAArmour.registerArmourSet("embrodium", EmbrodiumArmour.class);
    public static final ArmourSet ENGINEERING_ARMOUR = AoAArmour.registerArmourSet("engineering", EngineeringArmour.class);
    public static final ArmourSet EXOPLATE_ARMOUR = AoAArmour.registerArmourSet("exoplate", ExoplateArmour.class);
    public static final ArmourSet EXPEDITION_ARMOUR = AoAArmour.registerArmourSet("expedition", ExpeditionArmour.class);
    public static final ArmourSet EXPLOSIVE_ARMOUR = AoAArmour.registerArmourSet("explosive", ExplosiveArmour.class);
    public static final ArmourSet EXTRACTION_ARMOUR = AoAArmour.registerArmourSet("extraction", ExtractionArmour.class);
    public static final ArmourSet FORAGING_ARMOUR = AoAArmour.registerArmourSet("foraging", ForagingArmour.class);
    public static final ArmourSet FUNGAL_ARMOUR = AoAArmour.registerArmourSet("fungal", FungalArmour.class);
    public static final ArmourSet GHASTLY_ARMOUR = AoAArmour.registerArmourSet("ghastly", GhastlyArmour.class);
    public static final ArmourSet GHOULISH_ARMOUR = AoAArmour.registerArmourSet("ghoulish", GhoulishArmour.class);
    public static final ArmourSet HAULING_ARMOUR = AoAArmour.registerArmourSet("hauling", HaulingArmour.class);
    public static final ArmourSet HAZMAT_ARMOUR = AoAArmour.registerArmourSet("hazmat", HazmatArmour.class);
    public static final ArmourSet HUNTER_ARMOUR = AoAArmour.registerArmourSet("hunter", HunterArmour.class);
    public static final ArmourSet HYDRANGIC_ARMOUR = AoAArmour.registerArmourSet("hydrangic", HydrangicArmour.class);
    public static final ArmourSet HYDROPLATE_ARMOUR = AoAArmour.registerArmourSet("hydroplate", HydroplateArmour.class);
    public static final ArmourSet ICE_ARMOUR = AoAArmour.registerArmourSet("ice", IceArmour.class);
    public static final ArmourSet INFERNAL_ARMOUR = AoAArmour.registerArmourSet("infernal", InfernalArmour.class);
    public static final ArmourSet INFUSION_ARMOUR = AoAArmour.registerArmourSet("infusion", InfusionArmour.class);
    public static final ArmourSet INNERVATION_ARMOUR = AoAArmour.registerArmourSet("innervation", InnervationArmour.class);
    public static final ArmourSet KNIGHT_ARMOUR = AoAArmour.registerArmourSet("knight", KnightArmour.class);
    public static final ArmourSet LOGGING_ARMOUR = AoAArmour.registerArmourSet("logging", LoggingArmour.class);
    public static final ArmourSet LUNAR_ARMOUR = AoAArmour.registerArmourSet("lunar", LunarArmour.class);
    public static final ArmourSet LYNDAMYTE_ARMOUR = AoAArmour.registerArmourSet("lyndamyte", LyndamyteArmour.class);
    public static final ArmourSet LYONIC_ARMOUR = AoAArmour.registerArmourSet("lyonic", LyonicArmour.class);
    public static final ArmourSet MERCURIAL_ARMOUR = AoAArmour.registerArmourSet("mercurial", MercurialArmour.class);
    public static final ArmourSet NECRO_ARMOUR = AoAArmour.registerArmourSet("necro", NecroArmour.class);
    public static final ArmourSet NETHENGEIC_ARMOUR = AoAArmour.registerArmourSet("nethengeic", NethengeicArmour.class);
    public static final ArmourSet NIGHTMARE_ARMOUR = AoAArmour.registerArmourSet("nightmare", NightmareArmour.class);
    public static final ArmourSet OMNI_ARMOUR = AoAArmour.registerArmourSet("omni", OmniArmour.class);
    public static final ArmourSet PHANTASM_ARMOUR = AoAArmour.registerArmourSet("phantasm", PhantasmArmour.class);
    public static final ArmourSet POISON_ARMOUR = AoAArmour.registerArmourSet("poison", PoisonArmour.class);
    public static final ArmourSet PREDATIOUS_ARMOUR = AoAArmour.registerArmourSet("predatious", PredatiousArmour.class);
    public static final ArmourSet PRIMORDIAL_ARMOUR = AoAArmour.registerArmourSet("primordial", PrimordialArmour.class);
    public static final ArmourSet PURITY_ARMOUR = AoAArmour.registerArmourSet("purity", PurityArmour.class);
    public static final ArmourSet ROCKBONE_ARMOUR = AoAArmour.registerArmourSet("rockbone", RockboneArmour.class);
    public static final ArmourSet ROSIDIAN_ARMOUR = AoAArmour.registerArmourSet("rosidian", RosidianArmour.class);
    public static final ArmourSet RUNATION_ARMOUR = AoAArmour.registerArmourSet("runation", RunationArmour.class);
    public static final ArmourSet RUNIC_ARMOUR = AoAArmour.registerArmourSet("runic", RunicArmour.class);
    public static final ArmourSet SHARPSHOT_ARMOUR = AoAArmour.registerArmourSet("sharpshot", SharpshotArmour.class);
    public static final ArmourSet SKELETAL_ARMOUR = AoAArmour.registerArmourSet("skeletal", SkeletalArmour.class);
    public static final ArmourSet SPACEKING_ARMOUR = AoAArmour.registerArmourSet("spaceking", SpacekingArmour.class);
    public static final ArmourSet SPEED_ARMOUR = AoAArmour.registerArmourSet("speed", SpeedArmour.class);
    public static final ArmourSet SUBTERRANEAN_ARMOUR = AoAArmour.registerArmourSet("subterranean", SubterraneanArmour.class);
    public static final ArmourSet UTOPIAN_ARMOUR = AoAArmour.registerArmourSet("utopian", UtopianArmour.class);
    public static final ArmourSet VOID_ARMOUR = AoAArmour.registerArmourSet("void", VoidArmour.class);
    public static final ArmourSet WEAKEN_ARMOUR = AoAArmour.registerArmourSet("weaken", WeakenArmour.class);
    public static final ArmourSet WITHER_ARMOUR = AoAArmour.registerArmourSet("wither", WitherArmour.class);
    public static final ArmourSet ZARGONITE_ARMOUR = AoAArmour.registerArmourSet("zargonite", ZargoniteArmour.class);

    private static RegistryObject<Item> registerArmour(String registryName, Supplier<Item> item) {
        return ARMOUR.register(registryName, item);
    }

    private static ArmourSet registerArmourSet(String registryPrefix, Class<? extends AdventArmour> armourClass) {
        return new ArmourSet(registryPrefix, armourClass);
    }

    public static class ArmourSet {
        public final RegistryObject<Item> helmet;
        public final RegistryObject<Item> chestplate;
        public final RegistryObject<Item> leggings;
        public final RegistryObject<Item> boots;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArmourSet(String registryPrefix, Class<? extends AdventArmour> armourClass) {
            RegistryObject helm = null;
            RegistryObject chest = null;
            RegistryObject legs = null;
            RegistryObject boot = null;
            try {
                Constructor<? extends AdventArmour> constructor = armourClass.getConstructor(EquipmentSlotType.class);
                helm = ARMOUR.register(registryPrefix + "_helmet", () -> this.construct(constructor, EquipmentSlotType.HEAD));
                chest = ARMOUR.register(registryPrefix + "_chestplate", () -> this.construct(constructor, EquipmentSlotType.CHEST));
                legs = ARMOUR.register(registryPrefix + "_legs", () -> this.construct(constructor, EquipmentSlotType.LEGS));
                boot = ARMOUR.register(registryPrefix + "_boots", () -> this.construct(constructor, EquipmentSlotType.FEET));
            }
            catch (NoSuchMethodException ex) {
                Logging.logMessage(Level.ERROR, "Somehow we've managed to throw an error while registering armours. I'm really not even sure how this is possible.", ex);
            }
            finally {
                this.helmet = helm;
                this.chestplate = chest;
                this.leggings = legs;
                this.boots = boot;
            }
        }

        private AdventArmour construct(Constructor<? extends AdventArmour> constructor, EquipmentSlotType slot) {
            try {
                return constructor.newInstance(slot);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                Logging.logMessage(Level.ERROR, "Somehow we've managed to throw an error while registering armours. I'm really not even sure how this is possible.", ex);
                return null;
            }
        }
    }
}

