/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tslat.aoa3.worldgen.AoABiome;
import net.tslat.aoa3.worldgen.worlds.abyss.AbyssBiome;
import net.tslat.aoa3.worldgen.worlds.ancientcavern.AncientCavernBiome;
import net.tslat.aoa3.worldgen.worlds.barathos.BarathosBiome;
import net.tslat.aoa3.worldgen.worlds.candyland.CandylandBiome;
import net.tslat.aoa3.worldgen.worlds.celeve.CeleveBiome;
import net.tslat.aoa3.worldgen.worlds.creeponia.CreeponiaBiome;
import net.tslat.aoa3.worldgen.worlds.crystevia.CrysteviaBiome;
import net.tslat.aoa3.worldgen.worlds.deeplands.DeeplandsBiome;
import net.tslat.aoa3.worldgen.worlds.dustopia.DustopiaBiome;
import net.tslat.aoa3.worldgen.worlds.gardencia.GardenciaBiome;
import net.tslat.aoa3.worldgen.worlds.greckon.GreckonBiome;
import net.tslat.aoa3.worldgen.worlds.haven.HavenBiome;
import net.tslat.aoa3.worldgen.worlds.immortallis.ImmortallisBiome;
import net.tslat.aoa3.worldgen.worlds.iromine.IromineBiome;
import net.tslat.aoa3.worldgen.worlds.lborean.LBoreanBiome;
import net.tslat.aoa3.worldgen.worlds.lelyetia.LelyetiaBiome;
import net.tslat.aoa3.worldgen.worlds.lunalus.LunalusBiome;
import net.tslat.aoa3.worldgen.worlds.mysterium.MysteriumBiome;
import net.tslat.aoa3.worldgen.worlds.precasia.PrecasiaBiome;
import net.tslat.aoa3.worldgen.worlds.runandor.RunandorBiome;
import net.tslat.aoa3.worldgen.worlds.shyrelands.ShyrelandsBiome;
import net.tslat.aoa3.worldgen.worlds.voxponds.VoxPondsBiome;

public final class AoABiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"aoa3");
    public static final RegistryObject<AoABiome> ABYSS = AoABiomes.registerBiome("abyss", AbyssBiome::new);
    public static final RegistryObject<AoABiome> ANCIENT_CAVERN = AoABiomes.registerBiome("ancient_cavern", AncientCavernBiome::new);
    public static final RegistryObject<AoABiome> BARATHOS = AoABiomes.registerBiome("barathos", BarathosBiome::new);
    public static final RegistryObject<AoABiome> CANDYLAND = AoABiomes.registerBiome("candyland", CandylandBiome::new);
    public static final RegistryObject<AoABiome> CELEVE = AoABiomes.registerBiome("celeve", CeleveBiome::new);
    public static final RegistryObject<AoABiome> CREEPONIA = AoABiomes.registerBiome("creeponia", CreeponiaBiome::new);
    public static final RegistryObject<AoABiome> CRYSTEVIA = AoABiomes.registerBiome("crystevia", CrysteviaBiome::new);
    public static final RegistryObject<AoABiome> DEEPLANDS = AoABiomes.registerBiome("deeplands", DeeplandsBiome::new);
    public static final RegistryObject<AoABiome> DUSTOPIA = AoABiomes.registerBiome("dustopia", DustopiaBiome::new);
    public static final RegistryObject<AoABiome> GARDENCIA = AoABiomes.registerBiome("gardencia", GardenciaBiome::new);
    public static final RegistryObject<AoABiome> GRECKON = AoABiomes.registerBiome("greckon", GreckonBiome::new);
    public static final RegistryObject<AoABiome> HAVEN = AoABiomes.registerBiome("haven", HavenBiome::new);
    public static final RegistryObject<AoABiome> IMMORTALLIS = AoABiomes.registerBiome("immortallis", ImmortallisBiome::new);
    public static final RegistryObject<AoABiome> IROMINE = AoABiomes.registerBiome("iromine", IromineBiome::new);
    public static final RegistryObject<AoABiome> LBOREAN = AoABiomes.registerBiome("lborean", LBoreanBiome::new);
    public static final RegistryObject<AoABiome> LELYETIA = AoABiomes.registerBiome("lelyetia", LelyetiaBiome::new);
    public static final RegistryObject<AoABiome> LUNALUS = AoABiomes.registerBiome("lunalus", LunalusBiome::new);
    public static final RegistryObject<AoABiome> MYSTERIUM = AoABiomes.registerBiome("mysterium", MysteriumBiome::new);
    public static final RegistryObject<AoABiome> PRECASIA = AoABiomes.registerBiome("precasia", PrecasiaBiome::new);
    public static final RegistryObject<AoABiome> RUNANDOR = AoABiomes.registerBiome("runandor", RunandorBiome::new);
    public static final RegistryObject<AoABiome> SHYRELANDS = AoABiomes.registerBiome("shyrelands", ShyrelandsBiome::new);
    public static final RegistryObject<AoABiome> VOX_PONDS = AoABiomes.registerBiome("vox_ponds", VoxPondsBiome::new);

    private static RegistryObject<AoABiome> registerBiome(String id, Supplier<AoABiome> biome) {
        return BIOMES.register(id, biome);
    }

    public static void initBiomes() {
        for (RegistryObject biome : BIOMES.getEntries()) {
            BiomeDictionary.addTypes((Biome)((Biome)biome.get()), (BiomeDictionary.Type[])((AoABiome)biome.get()).getBiomeTypes());
        }
    }
}

