/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.worldgen.worlds.abyss.AbyssDimension;
import net.tslat.aoa3.worldgen.worlds.ancientcavern.AncientCavernDimension;
import net.tslat.aoa3.worldgen.worlds.barathos.BarathosDimension;
import net.tslat.aoa3.worldgen.worlds.candyland.CandylandDimension;
import net.tslat.aoa3.worldgen.worlds.celeve.CeleveDimension;
import net.tslat.aoa3.worldgen.worlds.creeponia.CreeponiaDimension;
import net.tslat.aoa3.worldgen.worlds.crystevia.CrysteviaDimension;
import net.tslat.aoa3.worldgen.worlds.deeplands.DeeplandsDimension;
import net.tslat.aoa3.worldgen.worlds.dustopia.DustopiaDimension;
import net.tslat.aoa3.worldgen.worlds.gardencia.GardenciaDimension;
import net.tslat.aoa3.worldgen.worlds.greckon.GreckonDimension;
import net.tslat.aoa3.worldgen.worlds.haven.HavenDimension;
import net.tslat.aoa3.worldgen.worlds.immortallis.ImmortallisDimension;
import net.tslat.aoa3.worldgen.worlds.iromine.IromineDimension;
import net.tslat.aoa3.worldgen.worlds.lborean.LBoreanDimension;
import net.tslat.aoa3.worldgen.worlds.lelyetia.LelyetiaDimension;
import net.tslat.aoa3.worldgen.worlds.lunalus.LunalusDimension;
import net.tslat.aoa3.worldgen.worlds.mysterium.MysteriumDimension;
import net.tslat.aoa3.worldgen.worlds.precasia.PrecasiaDimension;
import net.tslat.aoa3.worldgen.worlds.runandor.RunandorDimension;
import net.tslat.aoa3.worldgen.worlds.shyrelands.ShyrelandsDimension;
import net.tslat.aoa3.worldgen.worlds.voxponds.VoxPondsDimension;

@Mod.EventBusSubscriber(modid="aoa3")
public final class AoADimensions {
    public static final DeferredRegister<ModDimension> MOD_DIMENSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOD_DIMENSIONS, (String)"aoa3");
    private static final HashMap<DimensionType, AoADimension> dimTypeMap = new HashMap();
    public static final DimensionContainer ABYSS = new DimensionContainer(AoADimension.ABYSS, false, AbyssDimension::new);
    public static final DimensionContainer ANCIENT_CAVERN = new DimensionContainer(AoADimension.ANCIENT_CAVERN, false, AncientCavernDimension::new);
    public static final DimensionContainer BARATHOS = new DimensionContainer(AoADimension.BARATHOS, true, BarathosDimension::new);
    public static final DimensionContainer CANDYLAND = new DimensionContainer(AoADimension.CANDYLAND, true, CandylandDimension::new);
    public static final DimensionContainer CELEVE = new DimensionContainer(AoADimension.CELEVE, true, CeleveDimension::new);
    public static final DimensionContainer CREEPONIA = new DimensionContainer(AoADimension.CREEPONIA, true, CreeponiaDimension::new);
    public static final DimensionContainer CRYSTEVIA = new DimensionContainer(AoADimension.CRYSTEVIA, false, CrysteviaDimension::new);
    public static final DimensionContainer DEEPLANDS = new DimensionContainer(AoADimension.DEEPLANDS, false, DeeplandsDimension::new);
    public static final DimensionContainer DUSTOPIA = new DimensionContainer(AoADimension.DUSTOPIA, false, DustopiaDimension::new);
    public static final DimensionContainer GARDENCIA = new DimensionContainer(AoADimension.GARDENCIA, true, GardenciaDimension::new);
    public static final DimensionContainer GRECKON = new DimensionContainer(AoADimension.GRECKON, false, GreckonDimension::new);
    public static final DimensionContainer HAVEN = new DimensionContainer(AoADimension.HAVEN, true, HavenDimension::new);
    public static final DimensionContainer IMMORTALLIS = new DimensionContainer(AoADimension.IMMORTALLIS, false, ImmortallisDimension::new);
    public static final DimensionContainer IROMINE = new DimensionContainer(AoADimension.IROMINE, true, IromineDimension::new);
    public static final DimensionContainer LBOREAN = new DimensionContainer(AoADimension.LBOREAN, true, LBoreanDimension::new);
    public static final DimensionContainer LELYETIA = new DimensionContainer(AoADimension.LELYETIA, true, LelyetiaDimension::new);
    public static final DimensionContainer LUNALUS = new DimensionContainer(AoADimension.LUNALUS, false, LunalusDimension::new);
    public static final DimensionContainer MYSTERIUM = new DimensionContainer(AoADimension.MYSTERIUM, false, MysteriumDimension::new);
    public static final DimensionContainer PRECASIA = new DimensionContainer(AoADimension.PRECASIA, true, PrecasiaDimension::new);
    public static final DimensionContainer RUNANDOR = new DimensionContainer(AoADimension.RUNANDOR, true, RunandorDimension::new);
    public static final DimensionContainer SHYRELANDS = new DimensionContainer(AoADimension.SHYRELANDS, true, ShyrelandsDimension::new);
    public static final DimensionContainer VOX_PONDS = new DimensionContainer(AoADimension.VOX_PONDS, true, VoxPondsDimension::new);

    @SubscribeEvent
    public static void dimensionTypeRegister(RegisterDimensionsEvent ev) {
        Logging.logStatusMessage("Registering Dimension Types");
        AoADimensions.ABYSS.registerDimensionType();
        AoADimensions.ANCIENT_CAVERN.registerDimensionType();
        AoADimensions.BARATHOS.registerDimensionType();
        AoADimensions.CANDYLAND.registerDimensionType();
        AoADimensions.CELEVE.registerDimensionType();
        AoADimensions.CREEPONIA.registerDimensionType();
        AoADimensions.CRYSTEVIA.registerDimensionType();
        AoADimensions.DEEPLANDS.registerDimensionType();
        AoADimensions.DUSTOPIA.registerDimensionType();
        AoADimensions.GARDENCIA.registerDimensionType();
        AoADimensions.GRECKON.registerDimensionType();
        AoADimensions.HAVEN.registerDimensionType();
        AoADimensions.IMMORTALLIS.registerDimensionType();
        AoADimensions.IROMINE.registerDimensionType();
        AoADimensions.LBOREAN.registerDimensionType();
        AoADimensions.LELYETIA.registerDimensionType();
        AoADimensions.LUNALUS.registerDimensionType();
        AoADimensions.MYSTERIUM.registerDimensionType();
        AoADimensions.PRECASIA.registerDimensionType();
        AoADimensions.RUNANDOR.registerDimensionType();
        AoADimensions.SHYRELANDS.registerDimensionType();
        AoADimensions.VOX_PONDS.registerDimensionType();
        dimTypeMap.put(DimensionType.field_223228_b_, AoADimension.NETHER);
        dimTypeMap.put(DimensionType.field_223229_c_, AoADimension.END);
        dimTypeMap.put(DimensionType.field_223227_a_, AoADimension.OVERWORLD);
        dimTypeMap.put(null, AoADimension.NONE);
    }

    public static class DimensionContainer {
        AoADimension dim;
        private final boolean hasSkyLight;
        private final RegistryObject<ModDimension> modDim;
        private DimensionType dimType = null;

        private DimensionContainer(AoADimension dim, boolean hasSkyLight, final BiFunction<World, DimensionType, ? extends Dimension> modDimFactory) {
            this.dim = dim;
            this.hasSkyLight = hasSkyLight;
            this.modDim = MOD_DIMENSIONS.register(dim.toString().toLowerCase(Locale.ENGLISH), () -> new ModDimension(){

                public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
                    return modDimFactory;
                }
            });
        }

        private void registerDimensionType() {
            ResourceLocation dimId = new ResourceLocation("aoa3", this.dim.toString().toLowerCase(Locale.ENGLISH));
            this.dimType = DimensionManager.registerOrGetDimension((ResourceLocation)dimId, (ModDimension)((ModDimension)this.modDim.get()), (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)this.hasSkyLight);
            dimTypeMap.put(this.dimType, this.dim);
        }

        @Nonnull
        public DimensionType type() {
            if (this.dimType == null) {
                if (FMLEnvironment.dist == Dist.CLIENT) {
                    this.dimType = DimensionManager.registerOrGetDimension((ResourceLocation)new ResourceLocation("aoa3", this.dim.toString().toLowerCase(Locale.ENGLISH)), (ModDimension)((ModDimension)this.modDim.get()), (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)this.hasSkyLight);
                }
                if (this.dimType == null) {
                    throw new IllegalAccessError("Attempted to access dimensionType prior to DimensionType registration. This should not be happening.");
                }
            }
            return this.dimType;
        }
    }

    public static enum AoADimension {
        ABYSS,
        ANCIENT_CAVERN,
        BARATHOS,
        CANDYLAND,
        CELEVE,
        CREEPONIA,
        CRYSTEVIA,
        DEEPLANDS,
        END,
        DUSTOPIA,
        GARDENCIA,
        GRECKON,
        HAVEN,
        IMMORTALLIS,
        IROMINE,
        LBOREAN,
        LELYETIA,
        LUNALUS,
        MYSTERIUM,
        NETHER,
        OVERWORLD,
        PRECASIA,
        RUNANDOR,
        SHYRELANDS,
        VOX_PONDS,
        NONE;


        public static AoADimension fromDimType(DimensionType dimType) {
            return (AoADimension)((Object)dimTypeMap.get(dimType));
        }
    }
}

