/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tslat.aoa3.enchantment.ArchmageEnchantment;
import net.tslat.aoa3.enchantment.BraceEnchantment;
import net.tslat.aoa3.enchantment.ControlEnchantment;
import net.tslat.aoa3.enchantment.CrushEnchantment;
import net.tslat.aoa3.enchantment.FormEnchantment;
import net.tslat.aoa3.enchantment.GreedEnchantment;
import net.tslat.aoa3.enchantment.InterventionEnchantment;
import net.tslat.aoa3.enchantment.RechargeEnchantment;
import net.tslat.aoa3.enchantment.SeverEnchantment;
import net.tslat.aoa3.enchantment.ShellEnchantment;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.item.weapon.cannon.BaseCannon;
import net.tslat.aoa3.item.weapon.greatblade.BaseGreatblade;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.item.weapon.maul.BaseMaul;
import net.tslat.aoa3.item.weapon.shotgun.BaseShotgun;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;

public final class AoAEnchantments {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"aoa3");
    public static final EnchantmentType GUN = EnchantmentType.create((String)"GUN", item -> item instanceof BaseGun);
    public static final EnchantmentType GREATBLADE = EnchantmentType.create((String)"GREATBLADE", item -> item instanceof BaseGreatblade);
    public static final EnchantmentType SHOTGUN = EnchantmentType.create((String)"SHOTGUN", item -> item instanceof BaseShotgun);
    public static final EnchantmentType MAUL = EnchantmentType.create((String)"MAUL", item -> item instanceof BaseMaul);
    public static final EnchantmentType MELEE_WEAPON = EnchantmentType.create((String)"MELEE_WEAPON", item -> item instanceof SwordItem || item instanceof BaseGreatblade || item instanceof BaseMaul);
    public static final EnchantmentType STAFF = EnchantmentType.create((String)"STAFF", item -> item instanceof BaseStaff);
    public static final EnchantmentType AMMO_CONSUMING = EnchantmentType.create((String)"AMMO_CONSUMING", item -> item instanceof BaseGun || item instanceof BaseBlaster || item instanceof BaseStaff);
    public static final EnchantmentType BULLET_FIRING = EnchantmentType.create((String)"BULLET_FIRING", item -> item instanceof BaseGun && !(item instanceof BaseCannon));
    public static final EnchantmentType BLASTER = EnchantmentType.create((String)"BLASTER", item -> item instanceof BaseBlaster);
    public static final EnchantmentType UNSTACKABLE = EnchantmentType.create((String)"UNSTACKABLE", item -> item != null && item.getItemStackLimit(new ItemStack((IItemProvider)item)) == 0);
    public static final EnchantmentType LIGHT_GUN = EnchantmentType.create((String)"DUAL_WIELDABLE_GUN", item -> item instanceof BaseGun && !(item instanceof BaseSniper) && !(item instanceof BaseCannon));
    public static final RegistryObject<Enchantment> ARCHMAGE = AoAEnchantments.registerEnchantment("archmage", ArchmageEnchantment::new);
    public static final RegistryObject<Enchantment> BRACE = AoAEnchantments.registerEnchantment("brace", BraceEnchantment::new);
    public static final RegistryObject<Enchantment> CONTROL = AoAEnchantments.registerEnchantment("control", ControlEnchantment::new);
    public static final RegistryObject<Enchantment> CRUSH = AoAEnchantments.registerEnchantment("crush", CrushEnchantment::new);
    public static final RegistryObject<Enchantment> FORM = AoAEnchantments.registerEnchantment("form", FormEnchantment::new);
    public static final RegistryObject<Enchantment> GREED = AoAEnchantments.registerEnchantment("greed", GreedEnchantment::new);
    public static final RegistryObject<Enchantment> INTERVENTION = AoAEnchantments.registerEnchantment("intervention", InterventionEnchantment::new);
    public static final RegistryObject<Enchantment> RECHARGE = AoAEnchantments.registerEnchantment("recharge", RechargeEnchantment::new);
    public static final RegistryObject<Enchantment> SEVER = AoAEnchantments.registerEnchantment("sever", SeverEnchantment::new);
    public static final RegistryObject<Enchantment> SHELL = AoAEnchantments.registerEnchantment("shell", ShellEnchantment::new);

    private static RegistryObject<Enchantment> registerEnchantment(String id, Supplier<Enchantment> enchantment) {
        return ENCHANTMENTS.register(id, enchantment);
    }
}

