/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.AoABiomes;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.base.AoAAnimal;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.mob.creeponia.AoACreeponiaCreeper;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import org.apache.logging.log4j.Level;

public final class AoAEntitySpawns {
    private static boolean forceAllSpawns = false;
    private static final ArrayList<SpawnEntry<? extends MobEntity>> bigDaySpawns = new ArrayList(5);
    private static final ArrayList<SpawnEntry<? extends MobEntity>> bloodHuntSpawns = new ArrayList(3);
    private static final ArrayList<SpawnEntry<? extends MobEntity>> creepDaySpawns = new ArrayList(1);
    private static final ArrayList<SpawnEntry<? extends MobEntity>> deathDaySpawns = new ArrayList(4);
    private static final ArrayList<SpawnEntry<? extends MobEntity>> fullMoonSpawns = new ArrayList(5);
    private static final ArrayList<SpawnEntry<? extends MobEntity>> lunarInvasionSpawns = new ArrayList(5);
    private static final ArrayList<SpawnEntry<? extends MobEntity>> soulScurrySpawns = new ArrayList(6);

    public static void registerEntitySpawns() {
        Logging.logStatusMessage("Registering entity spawns");
        if (!((Boolean)AoAConfig.SERVER.disableOverworldMobs.get()).booleanValue()) {
            if (ModList.get().isLoaded("openterraingenerator")) {
                forceAllSpawns = true;
            }
            AoAEntitySpawns.addSpawns(AoAEntitySpawns.getOverworldSpawns(forceAllSpawns));
        }
        AoAEntitySpawns.addSpawns(AoAEntitySpawns.getNetherSpawns());
        AoAEntitySpawns.addSpawns(AoAEntitySpawns.getDimensionSpawns());
    }

    public static HashSet<SpawnEntry<? extends MobEntity>> getOverworldSpawns(boolean includeEventSpawns) {
        HashSet<SpawnEntry<? extends MobEntity>> spawns = new HashSet<SpawnEntry<? extends MobEntity>>();
        BiomeDictionary.Type[] emptyTypeList = new BiomeDictionary.Type[]{};
        Biome[] overworldBiomes = AoAEntitySpawns.getOverworldBiomes();
        Biome[] mountainBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN}, emptyTypeList);
        Biome[] snowyBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.SNOWY}, emptyTypeList);
        Biome[] sandyBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY}, emptyTypeList);
        Biome[] savannaBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.SAVANNA}, emptyTypeList);
        Biome[] jungleBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE}, emptyTypeList);
        Biome[] swampBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP}, emptyTypeList);
        Biome[] warmConiferousBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.CONIFEROUS}, new BiomeDictionary.Type[]{BiomeDictionary.Type.SNOWY});
        Biome[] mesaBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.MESA}, emptyTypeList);
        Biome[] oceanBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN}, emptyTypeList);
        Biome[] beachBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH}, emptyTypeList);
        Biome[] genericBiomes = AoAEntitySpawns.extractAllBiomesMatching(overworldBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.FOREST}, new BiomeDictionary.Type[]{BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SANDY});
        Biome[] genericPlainsBiomes = AoAEntitySpawns.extractAllBiomesMatching(genericBiomes, new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS}, emptyTypeList);
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BOMB_CARRIER.get(), 10, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.EVERBEAST.get(), 25, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FACELESS_RUNNER.get(), 85, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GHOST.get(), 85, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.MOTHER_VOID_WALKER.get(), 85, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SHADOW.get(), 85, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.TRICKSTER.get(), 60, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.VOID_CHARGER.get(), 85, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.VOID_WALKER.get(), 85, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BUGEYE.get(), 90, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DICER.get(), 55, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.NIGHT_REAPER.get(), 55, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DEMON_REAPER.get(), 21, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CLOWN.get(), 85, 1, 1, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        fullMoonSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.IRKLING.get(), 120, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        deathDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.REAPER_TWINS.get(), 80, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        lunarInvasionSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ROLOSCOPE.get(), 120, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        bigDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.WOOD_GIANT.get(), 70, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        deathDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.TRICLOPS.get(), 80, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        lunarInvasionSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.VERTEBRON.get(), 120, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        lunarInvasionSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.WALKER.get(), 90, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        deathDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HEADLESS_DESTROYER.get(), 80, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        bloodHuntSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BLOODMIST.get(), 80, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        bloodHuntSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.LINGER.get(), 80, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        soulScurrySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GHOSTLY_BUGEYE.get(), 120, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        soulScurrySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GHOSTLY_CHARGER.get(), 120, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        soulScurrySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GHOSTLY_CYCLOPS.get(), 120, 1, 3, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        soulScurrySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GHOSTLY_NIGHT_REAPER.get(), 120, 1, 3, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        soulScurrySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GHOSTLY_GOBLIN.get(), 120, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        soulScurrySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GHOSTLY_SASQUATCH.get(), 120, 1, 3, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        lunarInvasionSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.TERRESTRIAL.get(), 22, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        fullMoonSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SKELLOX.get(), 80, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        fullMoonSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SCRUBBY.get(), 80, 1, 3, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        fullMoonSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.NIGHT_WATCHER.get(), 80, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        fullMoonSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DARK_BEAST.get(), 80, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        creepDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HOST.get(), 60, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        deathDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DEATH_HUNTER.get(), 60, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        bloodHuntSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ANEMIA.get(), 55, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        lunarInvasionSpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.MODULO.get(), 120, 1, 2, overworldBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GOALBY.get(), 80, 1, 2, mountainBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GRUNT.get(), 40, 1, 2, mountainBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.MAGICKE.get(), 80, 1, 2, mountainBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        bigDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.STONE_GIANT.get(), 80, 1, 1, mountainBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HUNCH.get(), 70, 1, 2, snowyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.POLAR_URSA.get(), 70, 1, 1, snowyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.YETI.get(), 70, 1, 2, snowyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SNOW_CHARGER.get(), 70, 1, 2, snowyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        bigDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ICE_GIANT.get(), 70, 1, 1, snowyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DESERT_CHARGER.get(), 30, 1, 2, sandyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FURLION.get(), 30, 1, 3, sandyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SAND_GOLEM.get(), 30, 1, 2, sandyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SPHINX.get(), 30, 1, 2, sandyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.WICKETT.get(), 30, 1, 2, sandyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        bigDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SAND_GIANT.get(), 30, 1, 1, sandyBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CHIMERA.get(), 75, 1, 2, savannaBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BONEBACK.get(), 75, 1, 2, savannaBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.RAMMERHEAD.get(), 75, 1, 1, savannaBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.ELKANYNE.get(), 20, 2, 4, savannaBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BUSH_BABY.get(), 70, 1, 2, jungleBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.STINGER.get(), 70, 1, 1, jungleBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CHOMPER.get(), 70, 1, 1, swampBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SKIPPER.get(), 30, 1, 1, swampBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FISHIX.get(), 70, 1, 2, swampBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SWAMP_CHARGER.get(), 70, 1, 2, swampBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HAG.get(), 70, 1, 1, swampBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BLACK_URSA.get(), 70, 1, 1, warmConiferousBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HIDING_FUNGI.get(), 40, 1, 1, warmConiferousBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.NATURA.get(), 70, 1, 1, warmConiferousBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SKOLLE.get(), 15, 1, 3, warmConiferousBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.URKA.get(), 70, 1, 1, warmConiferousBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        bigDaySpawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.LEAFY_GIANT.get(), 70, 1, 1, warmConiferousBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HILL_CHARGER.get(), 50, 1, 3, mesaBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.MUCKOPEDE.get(), 50, 1, 1, mesaBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.PINCHER.get(), 1, 1, 1, oceanBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SEA_CHARGER.get(), 20, 1, 3, beachBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SPINUX.get(), 20, 1, 1, beachBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SEA_TROLL.get(), 20, 1, 1, beachBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.TROLL_TRADER.get(), 1, 0, 1, beachBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CYCLOPS.get(), 20, 1, 4, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CHARGER.get(), 20, 1, 2, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SASQUATCH.get(), 20, 1, 3, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HEADLESS_HUNTER.get(), 20, 1, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.GLISTENING_PIXON.get(), 30, 1, 4, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BONE_CREATURE.get(), 20, 1, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.KING_CHARGER.get(), 1, 1, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BRUTE.get(), 20, 1, 3, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GHOSTINE_ANCIENT.get(), 20, 1, 2, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GOBLIN.get(), 20, 1, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.ASSASSIN.get(), 1, 0, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.NATURALIST.get(), 1, 0, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.REALMSHIFTER.get(), 1, 0, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.LOTTOMAN.get(), 1, 0, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.NIGHTFLY.get(), 20, 1, 3, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        if ((Double)AoAConfig.SERVER.STRUCTURES.ruinedTeleporterFrameSpawnChance.get() == 0.0) {
            spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.CORRUPTED_TRAVELLER.get(), 1, 0, 1, genericBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        }
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HORNDRON.get(), 5, 1, 1, genericPlainsBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.WARCLOPS.get(), 5, 1, 2, genericPlainsBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ANCIENT_GOLEM.get(), 5, 1, 2, genericPlainsBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DEAD_TREE.get(), 10, 1, 1, new Biome[]{Biomes.field_76767_f, Biomes.field_76785_t}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        if (includeEventSpawns) {
            spawns.addAll(bigDaySpawns);
            spawns.addAll(creepDaySpawns);
            spawns.addAll(deathDaySpawns);
            spawns.addAll(fullMoonSpawns);
            spawns.addAll(bloodHuntSpawns);
            spawns.addAll(soulScurrySpawns);
            spawns.addAll(lunarInvasionSpawns);
        }
        return spawns;
    }

    public static HashSet<SpawnEntry<? extends MobEntity>> getNetherSpawns() {
        HashSet<SpawnEntry<? extends MobEntity>> spawns = new HashSet<SpawnEntry<? extends MobEntity>>();
        Biome[] netherBiomes = AoAEntitySpawns.biomes(BiomeDictionary.Type.NETHER);
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.WITHERING_LOTTOMAN.get(), 1, 0, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.EMBRAKE.get(), 60, 1, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FAKE_ZOMBIE_PIGMAN.get(), 80, 1, 2, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FLAMEWALKER.get(), 60, 1, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HELLSPOT.get(), 60, 1, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.INFERNAL.get(), 10, 1, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.WITHER_WIZARD.get(), 55, 1, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SKELETAL_COWMAN.get(), 45, 1, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HELLCAT.get(), 50, 1, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.LITTLE_BAM.get(), 20, 1, 1, netherBiomes).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        return spawns;
    }

    public static HashSet<SpawnEntry<? extends MobEntity>> getDimensionSpawns() {
        HashSet<SpawnEntry<? extends MobEntity>> spawns = new HashSet<SpawnEntry<? extends MobEntity>>();
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.BLOOMING_PIXON.get(), 12, 1, 4, new Biome[]{(Biome)AoABiomes.MYSTERIUM.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.RUNATION_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.MYSTERIUM.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.MYSTERIUM.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FUNGAT.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.MYSTERIUM.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FUNGBACK.get(), 15, 1, 1, new Biome[]{(Biome)AoABiomes.MYSTERIUM.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FUNGIK.get(), 15, 1, 1, new Biome[]{(Biome)AoABiomes.MYSTERIUM.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FUNGUNG.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.MYSTERIUM.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.EEO.get(), 15, 1, 1, new Biome[]{(Biome)AoABiomes.MYSTERIUM.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.GLARING_PIXON.get(), 12, 1, 4, new Biome[]{(Biome)AoABiomes.LELYETIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.LOGGING_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.LELYETIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.LELYETIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FLYE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LELYETIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GROBBLER.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.LELYETIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.LELYETIAN_CASTER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LELYETIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.LELYETIAN_WARRIOR.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LELYETIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.TRACKER.get(), 20, 0, 1, new Biome[]{(Biome)AoABiomes.LELYETIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.TROTTER.get(), 20, 2, 4, new Biome[]{(Biome)AoABiomes.LELYETIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.GLEAMING_PIXON.get(), 12, 1, 4, new Biome[]{(Biome)AoABiomes.RUNANDOR.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.ANIMA_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.RUNANDOR.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.RUNANDOR.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ARIEL.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.RUNANDOR.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BOUNCER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.RUNANDOR.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.EYE_CREATURE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.RUNANDOR.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.PALADIN.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.RUNANDOR.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.RUNICORN.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.RUNANDOR.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.RUNICORN_RIDER.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.RUNANDOR.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.GLOWING_PIXON.get(), 12, 1, 4, new Biome[]{(Biome)AoABiomes.LBOREAN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.HAULING_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.LBOREAN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.LBOREAN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ANGLER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LBOREAN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CORALON.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LBOREAN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.MUNCHER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LBOREAN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.NEPTUNO.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.LBOREAN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SEA_VIPER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LBOREAN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.CORATEE.get(), 20, 2, 4, new Biome[]{(Biome)AoABiomes.LBOREAN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.RADIANT_PIXON.get(), 12, 1, 4, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BASILISK.get(), 20, 0, 1, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DEVOURER.get(), 20, 0, 1, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DUSTON.get(), 20, 0, 1, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.LOST_SOUL.get(), 20, 0, 1, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DUSTEIVA.get(), 20, 0, 1, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.STALKER.get(), 20, 0, 1, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.STALKER_PRIME.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.LURKER.get(), 20, 0, 1, new Biome[]{(Biome)AoABiomes.DUSTOPIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.SHINING_PIXON.get(), 12, 1, 4, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.BUTCHERY_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.APPARITION.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BLOODSUCKER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DISTORTER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FIEND.get(), 20, 1, 2, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.OCCULENT.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.WEB_REAPER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SLIMER.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.ABYSS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.CREATION_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CRYPTID.get(), 30, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ARKBACK.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ECHODAR.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.EILOSAPIEN.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.NOSPIKE.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.EMPEROR_BEAST.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.PARASECT.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.KEELER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SQUIGGLER.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.THARAFLY.get(), 15, 1, 2, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.RAMRADON.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.BARATHOS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.CANDYLAND.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.AIRHEAD.get(), 20, 0, 1, new Biome[]{(Biome)AoABiomes.CANDYLAND.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CANDY_CORNY.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CANDYLAND.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CHERRY_BARRAGER.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.CANDYLAND.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.LOLLYPOPPER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CANDYLAND.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CHERRY_BLASTER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CANDYLAND.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.PEPPERMINT_SNAIL.get(), 20, 1, 3, new Biome[]{(Biome)AoABiomes.CANDYLAND.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.SPEARMINT_SNAIL.get(), 20, 1, 3, new Biome[]{(Biome)AoABiomes.CANDYLAND.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.CRYSTEVIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CONSTRUCT_OF_STRENGTH.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CRYSTEVIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CONSTRUCT_OF_RANGE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CRYSTEVIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CONSTRUCT_OF_TERROR.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CRYSTEVIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CONSTRUCT_OF_SPEED.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CRYSTEVIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CONSTRUCT_OF_RESISTANCE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CRYSTEVIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CONSTRUCT_OF_FLIGHT.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CRYSTEVIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CONSTRUCT_OF_MIND.get(), 2, 1, 1, new Biome[]{(Biome)AoABiomes.CRYSTEVIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.EXTRACTION_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CASE_CONSTRUCT.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DOUBLER.get(), 2, 1, 1, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DWELLER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CAVE_CREEP.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ROCKBITER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ROCK_CRITTER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ROCK_CRAWLER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.SHIK.get(), 5, 1, 3, new Biome[]{(Biome)AoABiomes.DEEPLANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.METALLOID.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.IROMINE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.FORAGING_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.IROMINE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.IROMINE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.MECHACHRON.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.IROMINE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.MECHAMATON.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.IROMINE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.POLYTOM.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.IROMINE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.QUICKPOCKET.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.IROMINE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.VOLTRON.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.IROMINE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ANGELICA.get(), 15, 1, 1, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.AUTOMATON.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ORBITER.get(), 15, 1, 1, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SEEKER.get(), 15, 1, 1, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.RAINICORN.get(), 2, 1, 1, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SURVEYOR.get(), 5, 1, 1, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.VOLAR.get(), 3, 1, 1, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.VOLIANT.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.HALYCON.get(), 5, 2, 4, new Biome[]{(Biome)AoABiomes.HAVEN.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.INFUSION_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.GRECKON.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.GRECKON.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GRILLFACE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GRECKON.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SHIFTER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GRECKON.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SILENCER.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.GRECKON.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SKULL_CREATURE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GRECKON.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SUGARFACE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GRECKON.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.VALKYRIE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GRECKON.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.HUNTER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GRECKON.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.INNERVATION_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BOBO.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CHOCKO.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.JUMBO.get(), 2, 1, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.KOKO.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.KRANKY.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SNAPPY.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.STICKY.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.STITCHES.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.TIPSY.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.CELEVE.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.LUNALUS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.EXPLODOT.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LUNALUS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.LUNARCHER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LUNALUS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.VISULAR.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.LUNALUS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.VISULON.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.LUNALUS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BONE_CREEPER.get(), 40, 1, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoACreeponiaCreeper::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CAVE_CREEPOID.get(), 25, 1, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoACreeponiaCreeper::meetsSpawnConditions));
        spawns.add(new SpawnEntry(EntityType.field_200797_k, 40, 1, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CREEPERLOCK.get(), 25, 1, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoACreeponiaCreeper::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CREEPIRD.get(), 15, 1, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CREEPUPLE.get(), 40, 1, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoACreeponiaCreeper::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.KING_CREEPER.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoACreeponiaCreeper::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.MAGICAL_CREEPER.get(), 25, 1, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoACreeponiaCreeper::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.WINGED_CREEPER.get(), 30, 1, 1, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoACreeponiaCreeper::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.CREEP_COW.get(), 5, 2, 4, new Biome[]{(Biome)AoABiomes.CREEPONIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.AMBIENT_PIXON.get(), 12, 1, 4, new Biome[]{(Biome)AoABiomes.HAVEN.get(), (Biome)AoABiomes.RUNANDOR.get(), (Biome)AoABiomes.CANDYLAND.get(), (Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.PRECASIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DYREHORN.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.PRECASIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GIANT_SNAIL.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.PRECASIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DEINOTHERIUM.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.PRECASIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SABRETOOTH.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.PRECASIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.TERRADON.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.PRECASIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.TORTIONE.get(), 3, 1, 1, new Biome[]{(Biome)AoABiomes.PRECASIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Animals.MEGANEUROPSIS.get(), 5, 1, 2, new Biome[]{(Biome)AoABiomes.PRECASIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAAnimal::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.VOX_PONDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.TOXXULOUS.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.VOX_PONDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GROCCULATE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.VOX_PONDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.GADGETOID.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.VOX_PONDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ALARMO.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.VOX_PONDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FISCHER.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.VOX_PONDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.DESTRUCTOR.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.VOX_PONDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CENTINEL.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.VOX_PONDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoARangedMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.GARDENCIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ARCHVINE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GARDENCIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.BROCCOHEAD.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GARDENCIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CARROTOP.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GARDENCIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.FLOWERFACE.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GARDENCIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SQUASHER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GARDENCIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SUNNY.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.GARDENCIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.CORNY.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.GARDENCIA.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.EXPEDITION_MASTER.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.NPCs.UNDEAD_HERALD.get(), 1, 0, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SYSKER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SHYRE_KNIGHT.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.AXIOLIGHT.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ARC_FLOWER.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.ARCBEAST.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.STIMULO.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.STIMULOSUS.get(), 1, 1, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.SOULVYRE.get(), 5, 1, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AoAMeleeMob::meetsSpawnConditions));
        spawns.add(new SpawnEntry((EntityType)AoAEntities.Mobs.OMNILIGHT.get(), 20, 1, 1, new Biome[]{(Biome)AoABiomes.SHYRELANDS.get()}).placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, AoAFlyingRangedMob::meetsSpawnConditions));
        return spawns;
    }

    private static Biome[] biomes(BiomeDictionary.Type ... biomeTypes) {
        ArrayList matchedBiomes = new ArrayList();
        for (BiomeDictionary.Type type : biomeTypes) {
            matchedBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        }
        return matchedBiomes.toArray(new Biome[0]);
    }

    private static Biome[] extractAllBiomesMatching(Biome[] preFilledList, BiomeDictionary.Type[] matchingTypes, BiomeDictionary.Type[] blacklistTypes) {
        ArrayList<Biome> passedBiomes = new ArrayList<Biome>();
        block0: for (Biome biome : preFilledList) {
            for (BiomeDictionary.Type goodType : matchingTypes) {
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)goodType)) continue;
                for (BiomeDictionary.Type badType : blacklistTypes) {
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)badType)) continue block0;
                }
                passedBiomes.add(biome);
            }
        }
        return passedBiomes.toArray(new Biome[0]);
    }

    private static Biome[] getOverworldBiomes() {
        ArrayList<Biome> suspectedOverworldBiomes = new ArrayList<Biome>();
        HashSet<Object> blacklist = new HashSet<Object>();
        blacklist.add(AoABiomes.ABYSS.get());
        blacklist.add(AoABiomes.ANCIENT_CAVERN.get());
        blacklist.add(AoABiomes.BARATHOS.get());
        blacklist.add(AoABiomes.CANDYLAND.get());
        blacklist.add(AoABiomes.CELEVE.get());
        blacklist.add(AoABiomes.CREEPONIA.get());
        blacklist.add(AoABiomes.CRYSTEVIA.get());
        blacklist.add(AoABiomes.DEEPLANDS.get());
        blacklist.add(AoABiomes.DUSTOPIA.get());
        blacklist.add(AoABiomes.GARDENCIA.get());
        blacklist.add(AoABiomes.GRECKON.get());
        blacklist.add(AoABiomes.HAVEN.get());
        blacklist.add(AoABiomes.IMMORTALLIS.get());
        blacklist.add(AoABiomes.IROMINE.get());
        blacklist.add(AoABiomes.LBOREAN.get());
        blacklist.add(AoABiomes.LELYETIA.get());
        blacklist.add(AoABiomes.LUNALUS.get());
        blacklist.add(AoABiomes.MYSTERIUM.get());
        blacklist.add(AoABiomes.PRECASIA.get());
        blacklist.add(AoABiomes.RUNANDOR.get());
        blacklist.add(AoABiomes.SHYRELANDS.get());
        blacklist.add(AoABiomes.VOX_PONDS.get());
        blacklist.add(Biomes.field_76778_j);
        blacklist.add(Biomes.field_185440_P);
        blacklist.add(Biomes.field_76779_k);
        blacklist.add(Biomes.field_76789_p);
        blacklist.add(Biomes.field_76788_q);
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (blacklist.contains(biome)) continue;
            suspectedOverworldBiomes.add(biome);
        }
        return suspectedOverworldBiomes.toArray(new Biome[0]);
    }

    public static void addEventSpawns(OverworldEvents.Event event) {
        if (forceAllSpawns) {
            return;
        }
        ArrayList<SpawnEntry<? extends MobEntity>> spawnList = null;
        switch (event) {
            case BIG_DAY: {
                spawnList = bigDaySpawns;
                break;
            }
            case CREEP_DAY: {
                spawnList = creepDaySpawns;
                break;
            }
            case DEATH_DAY: {
                spawnList = deathDaySpawns;
                break;
            }
            case FULL_MOON: {
                spawnList = fullMoonSpawns;
                break;
            }
            case BLOOD_HUNT: {
                spawnList = bloodHuntSpawns;
                break;
            }
            case SOUL_SCURRY: {
                spawnList = soulScurrySpawns;
                break;
            }
            case LUNAR_INVASION: {
                spawnList = lunarInvasionSpawns;
            }
        }
        AoAEntitySpawns.addSpawns(spawnList);
    }

    public static void removeEventSpawns(OverworldEvents.Event event) {
        if (forceAllSpawns) {
            return;
        }
        ArrayList<SpawnEntry<? extends MobEntity>> spawnList = null;
        switch (event) {
            case BIG_DAY: {
                spawnList = bigDaySpawns;
                break;
            }
            case CREEP_DAY: {
                spawnList = creepDaySpawns;
                break;
            }
            case DEATH_DAY: {
                spawnList = deathDaySpawns;
                break;
            }
            case FULL_MOON: {
                spawnList = fullMoonSpawns;
                break;
            }
            case BLOOD_HUNT: {
                spawnList = bloodHuntSpawns;
                break;
            }
            case SOUL_SCURRY: {
                spawnList = soulScurrySpawns;
                break;
            }
            case LUNAR_INVASION: {
                spawnList = lunarInvasionSpawns;
            }
        }
        AoAEntitySpawns.removeSpawns(spawnList);
    }

    public static void addSpawns(Collection<SpawnEntry<? extends MobEntity>> spawns) {
        spawns.forEach(entry -> AoAEntitySpawns.addSpawn(entry.entityType, entry.weight, entry.minGroupSize, entry.maxGroupSize, entry.biomes));
    }

    public static void removeSpawns(Collection<SpawnEntry<? extends MobEntity>> spawns) {
        spawns.forEach(entry -> AoAEntitySpawns.removeSpawn(entry.entityType, entry.biomes));
    }

    public static void addSpawn(EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize, Biome ... biomes) {
        for (Biome biome : biomes) {
            if (biome == null) continue;
            biome.func_76747_a(entityType.func_220339_d()).add(new Biome.SpawnListEntry(entityType, weight, minGroupSize, maxGroupSize));
        }
    }

    public static void removeSpawn(EntityType<?> entityType, Biome ... biomes) {
        for (Biome biome : biomes) {
            biome.func_76747_a(entityType.func_220339_d()).removeIf(entry -> entry.field_200702_b == entityType);
        }
    }

    public static class SpawnEntry<T extends MobEntity> {
        public final EntityType<T> entityType;
        public final int weight;
        public final int minGroupSize;
        public final int maxGroupSize;
        public final Biome[] biomes;

        private SpawnEntry(EntityType<T> entityType, int weight, int minGroupSize, int maxGroupSize, Biome ... biomes) {
            this.entityType = entityType;
            this.weight = weight;
            this.minGroupSize = minGroupSize;
            this.maxGroupSize = maxGroupSize;
            this.biomes = biomes;
        }

        private SpawnEntry<T> placement(EntitySpawnPlacementRegistry.PlacementType type, Heightmap.Type heightmap, EntitySpawnPlacementRegistry.IPlacementPredicate<T> spawnPredicate) {
            try {
                if (EntitySpawnPlacementRegistry.func_209344_a(this.entityType) == EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS) {
                    EntitySpawnPlacementRegistry.func_209343_a(this.entityType, (EntitySpawnPlacementRegistry.PlacementType)type, (Heightmap.Type)heightmap, spawnPredicate);
                }
            }
            catch (IllegalStateException ex) {
                Logging.logMessage(Level.WARN, "Caught duplicate spawn placement registration from: " + this.entityType.getRegistryName().toString());
            }
            return this;
        }
    }
}

