/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tslat.aoa3.client.particle.FlickeringSparklerParticle;
import net.tslat.aoa3.client.particle.LingeringSparklerParticle;
import net.tslat.aoa3.client.particle.PortalFloaterParticle;
import net.tslat.aoa3.client.particle.RainbowSparklerParticle;
import net.tslat.aoa3.client.particle.SparklerParticle;
import net.tslat.aoa3.client.particle.SwirlyParticle;
import net.tslat.aoa3.library.misc.CustomisableParticleType;

@Mod.EventBusSubscriber(modid="aoa3", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class AoAParticleTypes {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"aoa3");
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> SPARKLER = AoAParticleTypes.registerParticle("sparkler", () -> new CustomisableParticleType(true));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> FLICKERING_SPARKLER = AoAParticleTypes.registerParticle("flickering_sparkler", () -> new CustomisableParticleType(true));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> RAINBOW_SPARKLER = AoAParticleTypes.registerParticle("rainbow_sparkler", () -> new CustomisableParticleType(true));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> LINGERING_SPARKLER = AoAParticleTypes.registerParticle("lingering_sparkler", () -> new CustomisableParticleType(true));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> PORTAL_FLOATER = AoAParticleTypes.registerParticle("portal_floater", () -> new CustomisableParticleType(false));
    public static final RegistryObject<ParticleType<CustomisableParticleType.Data>> SWIRLY = AoAParticleTypes.registerParticle("swirly", () -> new CustomisableParticleType(true));

    private static <T extends IParticleData> RegistryObject<ParticleType<T>> registerParticle(String id, Supplier<? extends ParticleType<T>> particle) {
        return PARTICLES.register(id, particle);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void particleFactoryRegister(ParticleFactoryRegisterEvent ev) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)PORTAL_FLOATER.get(), PortalFloaterParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)SPARKLER.get(), SparklerParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)FLICKERING_SPARKLER.get(), FlickeringSparklerParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)LINGERING_SPARKLER.get(), LingeringSparklerParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)RAINBOW_SPARKLER.get(), RainbowSparklerParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)SWIRLY.get(), SwirlyParticle.Factory::new);
    }
}

