/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tslat.aoa3.worldgen.carvers.AbyssCaveCarver;
import net.tslat.aoa3.worldgen.carvers.BarathosCaveCarver;
import net.tslat.aoa3.worldgen.carvers.CreeponiaCaveCarver;
import net.tslat.aoa3.worldgen.carvers.GreckonCaveCarver;
import net.tslat.aoa3.worldgen.carvers.IromineCaveCarver;
import net.tslat.aoa3.worldgen.carvers.PrecasiaCaveCarver;
import net.tslat.aoa3.worldgen.chunkgenerator.AdjustableOceanChunkBuilder;
import net.tslat.aoa3.worldgen.chunkgenerator.CavernChunkBuilder;
import net.tslat.aoa3.worldgen.chunkgenerator.GenericAoAChunkBuilder;
import net.tslat.aoa3.worldgen.chunkgenerator.StructureChunkBuilder;
import net.tslat.aoa3.worldgen.chunkgenerator.config.CavernGenerationSettings;
import net.tslat.aoa3.worldgen.features.BiomeFriendlyLakeFeature;
import net.tslat.aoa3.worldgen.structures.nether.proper.FireRuneShrinePiece;
import net.tslat.aoa3.worldgen.structures.nether.proper.FireRuneShrineStructure;
import net.tslat.aoa3.worldgen.structures.nether.proper.NethengeicPitPiece;
import net.tslat.aoa3.worldgen.structures.nether.proper.NethengeicPitStructure;
import net.tslat.aoa3.worldgen.structures.overworld.proper.AmphibiyteCovePiece;
import net.tslat.aoa3.worldgen.structures.overworld.proper.AmphibiyteCoveStructure;
import net.tslat.aoa3.worldgen.structures.overworld.proper.RuinedTeleporterFramePiece;
import net.tslat.aoa3.worldgen.structures.overworld.proper.RuinedTeleporterFrameStructure;
import net.tslat.aoa3.worldgen.structures.overworld.proper.WindRuneShrinePiece;
import net.tslat.aoa3.worldgen.structures.overworld.proper.WindRuneShrineStructure;
import net.tslat.aoa3.worldgen.surfacebuilder.OceanlessSurfaceBuilder;
import net.tslat.aoa3.worldgen.surfacebuilder.TieredSurfaceBuilder;
import net.tslat.aoa3.worldgen.surfacebuilder.VoidSurfaceBuilder;
import net.tslat.aoa3.worldgen.surfacebuilder.config.TieredSurfaceBuilderConfig;

public final class AoAWorldGen {

    public static class Features {
        public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"aoa3");
        public static final Supplier<Feature<BlockStateFeatureConfig>> BIOME_FRIENDLY_LAKE = Features.register("biome_friendly_lake", () -> new BiomeFriendlyLakeFeature(BlockStateFeatureConfig::func_227271_a_));

        private static <C extends IFeatureConfig> Supplier<Feature<C>> register(String id, Supplier<Feature<C>> feature) {
            FEATURES.register(id, feature);
            return feature;
        }
    }

    public static class Structures {
        public static final DeferredRegister<Feature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"aoa3");
        public static final IStructurePieceType AMCOVE = Structures.register(AmphibiyteCovePiece::new, "AoAAmCove");
        public static final IStructurePieceType RTFrame = Structures.register(RuinedTeleporterFramePiece::new, "AoARTFrame");
        public static final IStructurePieceType WRShrine = Structures.register(WindRuneShrinePiece::new, "WRShrine");
        public static final IStructurePieceType NethPit = Structures.register(NethengeicPitPiece::new, "NethPit");
        public static final IStructurePieceType FRShrine = Structures.register(FireRuneShrinePiece::new, "FRShrine");
        public static final RegistryObject<? extends Feature<?>> AMPHIBIYTE_COVE = Structures.register("amphibiyte_cove", () -> new AmphibiyteCoveStructure(NoFeatureConfig::func_214639_a));
        public static final RegistryObject<? extends Feature<?>> WIND_RUNE_SHRINE = Structures.register("wind_rune_shrine", () -> new WindRuneShrineStructure(NoFeatureConfig::func_214639_a));
        public static final RegistryObject<? extends Feature<?>> RUINED_TELEPORTER_FRAME = Structures.register("ruined_teleporter_frame", () -> new RuinedTeleporterFrameStructure(NoFeatureConfig::func_214639_a));
        public static final RegistryObject<? extends Feature<?>> NETHENGEIC_PIT = Structures.register("nethengeic_pit", () -> new NethengeicPitStructure(NoFeatureConfig::func_214639_a));
        public static final RegistryObject<? extends Feature<?>> FIRE_RUNE_SHRINE = Structures.register("fire_rune_shrine", () -> new FireRuneShrineStructure(NoFeatureConfig::func_214639_a));

        private static RegistryObject<? extends Feature<?>> register(String id, Supplier<Feature<?>> structure) {
            return STRUCTURES.register(id, structure);
        }

        private static IStructurePieceType register(IStructurePieceType type, String key) {
            return (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)key.toLowerCase(Locale.ROOT), (Object)type);
        }
    }

    public static class Carvers {
        public static final DeferredRegister<WorldCarver<?>> CARVERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.WORLD_CARVERS, (String)"aoa3");
        public static final WorldCarver<ProbabilityConfig> ABYSS_CAVES;
        public static final WorldCarver<ProbabilityConfig> BARATHOS_CAVES;
        public static final WorldCarver<ProbabilityConfig> CREEPONIA_CAVES;
        public static final WorldCarver<ProbabilityConfig> GRECKON_CAVES;
        public static final WorldCarver<ProbabilityConfig> IROMINE_CAVES;
        public static final WorldCarver<ProbabilityConfig> PRECASIA_CAVES;

        private static void registerWorldCarvers() {
            CARVERS.register("abyss_caves", () -> ABYSS_CAVES);
            CARVERS.register("barathos_caves", () -> BARATHOS_CAVES);
            CARVERS.register("creeponia_caves", () -> CREEPONIA_CAVES);
            CARVERS.register("greckon_caves", () -> GRECKON_CAVES);
            CARVERS.register("iromine_caves", () -> IROMINE_CAVES);
            CARVERS.register("precasia_caves", () -> PRECASIA_CAVES);
        }

        static {
            Carvers.registerWorldCarvers();
            ABYSS_CAVES = new AbyssCaveCarver(ProbabilityConfig::func_214645_a, 256);
            BARATHOS_CAVES = new BarathosCaveCarver(ProbabilityConfig::func_214645_a, 256);
            CREEPONIA_CAVES = new CreeponiaCaveCarver(ProbabilityConfig::func_214645_a, 256);
            GRECKON_CAVES = new GreckonCaveCarver(ProbabilityConfig::func_214645_a, 256);
            IROMINE_CAVES = new IromineCaveCarver(ProbabilityConfig::func_214645_a, 256);
            PRECASIA_CAVES = new PrecasiaCaveCarver(ProbabilityConfig::func_214645_a, 256);
        }
    }

    public static class ChunkGeneratorTypes {
        public static final DeferredRegister<ChunkGeneratorType<?, ?>> CHUNKGEN_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CHUNK_GENERATOR_TYPES, (String)"aoa3");
        public static final RegistryObject<ChunkGeneratorType<GenerationSettings, GenericAoAChunkBuilder>> GENERIC = ChunkGeneratorTypes.registerChunkGenerator("generic", () -> new ChunkGeneratorType(GenericAoAChunkBuilder::new, true, GenerationSettings::new));
        public static final RegistryObject<ChunkGeneratorType<GenerationSettings, StructureChunkBuilder>> STRUCTURE = ChunkGeneratorTypes.registerChunkGenerator("structure", () -> new ChunkGeneratorType(StructureChunkBuilder::new, false, GenerationSettings::new));
        public static final RegistryObject<ChunkGeneratorType<OverworldGenSettings, AdjustableOceanChunkBuilder>> ADJUSTABLE_OCEAN = ChunkGeneratorTypes.registerChunkGenerator("adjustable_ocean", () -> new ChunkGeneratorType(AdjustableOceanChunkBuilder::new, false, OverworldGenSettings::new));
        public static final RegistryObject<ChunkGeneratorType<CavernGenerationSettings, CavernChunkBuilder>> CAVERN = ChunkGeneratorTypes.registerChunkGenerator("cavern", () -> new ChunkGeneratorType(CavernChunkBuilder::new, false, CavernGenerationSettings::new));

        private static <S extends GenerationSettings, B extends ChunkGenerator<S>> RegistryObject<ChunkGeneratorType<S, B>> registerChunkGenerator(String id, Supplier<ChunkGeneratorType<S, B>> chunkGenerator) {
            return CHUNKGEN_TYPES.register(id, chunkGenerator);
        }
    }

    public static class SurfaceBuilders {
        public static final DeferredRegister<SurfaceBuilder<?>> SURFACE_BUILDERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SURFACE_BUILDERS, (String)"aoa3");
        public static final SurfaceBuilder<SurfaceBuilderConfig> OCEANLESS;
        public static final SurfaceBuilder<SurfaceBuilderConfig> VOID;
        public static final SurfaceBuilder<TieredSurfaceBuilderConfig> TIERED;

        private static void registerSurfaceBuilders() {
            SURFACE_BUILDERS.register("oceanless", () -> OCEANLESS);
            SURFACE_BUILDERS.register("void", () -> VOID);
            SURFACE_BUILDERS.register("tiered", () -> TIERED);
        }

        static {
            SurfaceBuilders.registerSurfaceBuilders();
            OCEANLESS = new OceanlessSurfaceBuilder(SurfaceBuilderConfig::func_215455_a);
            VOID = new VoidSurfaceBuilder(dataFixer -> new SurfaceBuilderConfig(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P()));
            TIERED = new TieredSurfaceBuilder(TieredSurfaceBuilderConfig::deserialize);
        }
    }
}

