/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.tslat.aoa3.client.gui.hud.ResourcesRenderer;
import net.tslat.aoa3.library.misc.AoAHalos;

public final class ClientConfig {
    public final ForgeConfigSpec.BooleanValue doVerboseDebugging;
    public final ForgeConfigSpec.BooleanValue showVanityLevels;
    public final ForgeConfigSpec.BooleanValue showXpParticles;
    public final ForgeConfigSpec.BooleanValue showWelcomeMessage;
    public final ForgeConfigSpec.BooleanValue showPlayerHalos;
    public final ForgeConfigSpec.EnumValue<AoAHalos.Type.Choosable> personalHaloPreference;
    public final ForgeConfigSpec.ConfigValue<String> adventGuiTheme;
    public final ForgeConfigSpec.BooleanValue adventGuiPausesGame;
    public final ForgeConfigSpec.BooleanValue thirdPartyBestiary;
    public final ForgeConfigSpec.EnumValue<ResourcesRenderer.HudResourcesPosition> hudResourcesPosition;
    public final ForgeConfigSpec.BooleanValue hudResourcesHorizontal;
    public final ForgeConfigSpec.BooleanValue disableHudPotionOffset;
    public final ForgeConfigSpec.BooleanValue useToasts;
    public final ForgeConfigSpec.BooleanValue rotatingTrophies;
    public final ForgeConfigSpec.BooleanValue partyDeaths;
    public final ForgeConfigSpec.BooleanValue alwaysChargers;

    protected ClientConfig(ForgeConfigSpec.Builder specBuilder) {
        specBuilder.comment("AoA client-side configuration options").push("General Settings");
        this.doVerboseDebugging = specBuilder.comment(new String[]{"Set this to true to enable more detailed debugging.", "If you don't mind your logs having a bit more info, or you are trying to figure out a bug or crash, this can be very helpful to have"}).translation("config.aoa3.doVerboseDebugging").define("doVerboseDebugging", false);
        this.showVanityLevels = specBuilder.comment(new String[]{"Set this to false to limit your levels display to a max of level 100.", "Levels above this are for prestige only and do not affect your gameplay"}).translation("config.aoa3.showVanityLevels").define("showVanityLevels", true);
        this.showXpParticles = specBuilder.comment("Set this to false to disable the small scrolling popups that appear when you gain xp in a skill").translation("config.aoa3.showXpParticles").define("showXpParticles", true);
        this.showWelcomeMessage = specBuilder.comment("Set this to false to disable the message that welcomes you to Advent of Ascension when logging in").translation("config.aoa3.showWelcomeMessage").define("showWelcomeMessage", true);
        this.showPlayerHalos = specBuilder.comment("Set this to false to hide player halos for those that have them").translation("config.aoa3.showPlayerHalos").define("showPlayerHalos", true);
        this.personalHaloPreference = specBuilder.comment("If multiple halos are available, which one would you prefer to have on?").translation("config.aoa3.personalHaloPreference").defineEnum("personalHaloPreference", (Enum)AoAHalos.Type.Choosable.Donator);
        this.adventGuiTheme = specBuilder.comment("The current theme for the main Advent of Ascension window.").translation("config.aoa3.adventGuiTheme").define("adventGuiTheme", (Object)"Default");
        this.adventGuiPausesGame = specBuilder.comment("Setting this to false allows the game to continue running as normal while the Advent of Ascension GUI is open.").translation("config.aoa3.adventGuiPausesGame").define("adventGuiPausesGame", true);
        this.thirdPartyBestiary = specBuilder.comment("Set this to false to disable third party and vanilla entities from showing in the bestiary").translation("config.aoa3.thirdPartyBestiary").define("thirdPartyBestiary", true);
        this.hudResourcesPosition = specBuilder.comment("Choose a corner to have your resources indicators render in.").translation("config.aoa3.hudResourcesPosition").defineEnum("hudResourcesPosition", (Enum)ResourcesRenderer.HudResourcesPosition.Top_Right);
        this.hudResourcesHorizontal = specBuilder.comment("Set this to false to switch to a vertical layout for the HUD resources").translation("config.aoa3.hudResourcesHorizontal").define("hudResourcesHorizontal", true);
        this.disableHudPotionOffset = specBuilder.comment("Set this to true to stop the skills and resources HUD elements shifting down when players have potion effects.").translation("config.aoa3.disableHudPotionOffset").define("disableHudPotionOffset", false);
        this.useToasts = specBuilder.comment("Set this to false to use chat messages for mod feedback instead of toasts").translation("config.aoa3.useToasts").define("useToasts", true);
        this.rotatingTrophies = specBuilder.comment("Set this to false to disable rotation of entities on trophy blocks.").translation("config.aoa3.rotatingTrophies").define("rotatingTrophies", true);
        specBuilder.pop();
        specBuilder.comment("Just for fun :)").push("Fun Options");
        this.partyDeaths = specBuilder.comment("Set this to true to enable party deaths").translation("config.aoa3.partyDeaths").define("partyDeaths", false);
        this.alwaysChargers = specBuilder.comment("Set this to true for Chargers. All the chargers").translation("config.aoa3.alwaysChargers").define("alwaysChargers", false);
        specBuilder.pop();
    }

    public void changeAdventGuiTheme(String themeKey) {
        this.adventGuiTheme.set((Object)themeKey);
        this.adventGuiTheme.save();
    }
}

