/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;

public class AdventBowAttackGoal<T extends MobEntity>
extends Goal {
    private final T shooter;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public AdventBowAttackGoal(T shooter, double moveSpeedAmplifier, int attackCooldown, float maxAttackDistance) {
        this.shooter = shooter;
        this.moveSpeedAmp = moveSpeedAmplifier;
        this.attackCooldown = attackCooldown;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public boolean func_75250_a() {
        return this.shooter.func_70638_az() != null && this.isBowInMainhand();
    }

    protected boolean isBowInMainhand() {
        return this.shooter.func_184614_ca().func_77973_b() instanceof BowItem || this.shooter.func_184592_cb().func_77973_b() instanceof BowItem;
    }

    public boolean func_75253_b() {
        return (this.func_75250_a() || !this.shooter.func_70661_as().func_75500_f()) && this.isBowInMainhand();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.shooter.func_213395_q(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.shooter.func_213395_q(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.shooter.func_184602_cy();
    }

    public void func_75246_d() {
        LivingEntity target = this.shooter.func_70638_az();
        if (target != null) {
            double distanceToTarget = this.shooter.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            boolean canSeeTarget = this.shooter.func_70635_at().func_75522_a((Entity)target);
            if (canSeeTarget != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            if (!(distanceToTarget > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                this.shooter.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.shooter.func_70661_as().func_75497_a((Entity)target, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.shooter.func_70681_au().nextFloat() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.shooter.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distanceToTarget > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distanceToTarget < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.shooter.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.shooter.func_70625_a((Entity)target, 30.0f, 30.0f);
            } else {
                this.shooter.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            }
            if (this.shooter.func_184587_cr()) {
                int maxItemUseTime;
                if (!canSeeTarget && this.seeTime < -60) {
                    this.shooter.func_184602_cy();
                } else if (canSeeTarget && (maxItemUseTime = this.shooter.func_184612_cw()) >= 20) {
                    this.shooter.func_184602_cy();
                    ((IRangedAttackMob)this.shooter).func_82196_d(target, BowItem.func_185059_b((int)maxItemUseTime));
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.shooter.func_184598_c(ProjectileHelper.func_221274_a(this.shooter, (Item)Items.field_151031_f));
            }
        }
    }
}

