/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.animal;

import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.ai.mob.RandomFlyingGoal;
import net.tslat.aoa3.entity.ai.movehelper.RoamingFlightMoveHelper;
import net.tslat.aoa3.entity.base.AoAAnimal;

public class MeganeuropsisEntity
extends AoAAnimal {
    private static final DataParameter<Boolean> LANDED = EntityDataManager.func_187226_a(MeganeuropsisEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> START_LANDING_TICKS = EntityDataManager.func_187226_a(MeganeuropsisEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Direction> LANDING_DIRECTION = EntityDataManager.func_187226_a(MeganeuropsisEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Optional<UUID>> LANDED_PLAYER = EntityDataManager.func_187226_a(MeganeuropsisEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private PlayerEntity clientRidingPlayer = null;
    private int clientStartLandingTicks = 0;

    public MeganeuropsisEntity(EntityType<? extends AnimalEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new RoamingFlightMoveHelper((MobEntity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LANDED, (Object)false);
        this.field_70180_af.func_187214_a(START_LANDING_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(LANDING_DIRECTION, (Object)Direction.DOWN);
        this.field_70180_af.func_187214_a(LANDED_PLAYER, Optional.empty());
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new EntityAIMeganeuropsisLand(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomFlyingGoal((MobEntity)this, true));
    }

    protected PathNavigator func_175447_b(World world) {
        return new FlyingPathNavigator((MobEntity)this, world);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 0.3125f;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 9.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.5;
    }

    @Override
    protected double getBaseArmor() {
        return 1.0;
    }

    public int getStartLandingTicks() {
        return this.field_70170_p.field_72995_K ? this.clientStartLandingTicks : (Integer)this.field_70180_af.func_187225_a(START_LANDING_TICKS);
    }

    public boolean isLanded() {
        return (Boolean)this.field_70180_af.func_187225_a(LANDED);
    }

    public Direction getLandingDirection() {
        return (Direction)this.field_70180_af.func_187225_a(LANDING_DIRECTION);
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)AoASounds.ENTITY_MEGANEUROPSIS_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_MEGANEUROPSIS_DEATH.get();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_MEGANEUROPSIS_AMBIENT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && key == START_LANDING_TICKS) {
            this.clientStartLandingTicks = this.field_70173_aa;
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_213352_e(Vec3d motion) {
        if (this.isLanded()) {
            PlayerEntity pl;
            if (this.field_70170_p.field_72995_K && this.getLandingDirection() == Direction.DOWN && !this.func_184218_aH() && ((Optional)this.field_70180_af.func_187225_a(LANDED_PLAYER)).isPresent() && (pl = this.field_70170_p.func_217371_b((UUID)((Optional)this.field_70180_af.func_187225_a(LANDED_PLAYER)).get())) != null) {
                this.clientRidingPlayer = pl;
                this.func_184205_a((Entity)this.clientRidingPlayer, false);
            }
            return;
        }
        if (this.field_70170_p.field_72995_K && this.func_184218_aH() && this.clientRidingPlayer != null) {
            this.clientRidingPlayer = null;
            this.func_184210_p();
        }
        if (this.func_70090_H()) {
            this.func_213309_a(0.02f, motion);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.8));
        } else if (this.func_180799_ab()) {
            this.func_213309_a(0.02f, motion);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        } else {
            BlockState underState;
            BlockPos underPos;
            float friction = 0.91f;
            if (this.field_70122_E) {
                underPos = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.func_226281_cx_()));
                underState = this.field_70170_p.func_180495_p(underPos);
                friction = underState.func_177230_c().getSlipperiness(underState, (IWorldReader)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_213309_a(this.field_70122_E ? 0.1f * (0.16277136f / (friction * friction * friction)) : 0.02f, motion);
            friction = 0.91f;
            if (this.field_70122_E) {
                underPos = new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.func_226281_cx_()));
                underState = this.field_70170_p.func_180495_p(underPos);
                friction = underState.func_177230_c().getSlipperiness(underState, (IWorldReader)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)friction));
        }
        this.field_184618_aE = this.field_70721_aZ;
        double movedX = this.func_226281_cx_() - this.field_70169_q;
        double movedZ = this.func_226281_cx_() - this.field_70166_s;
        float totalMotion = MathHelper.func_76133_a((double)(movedX * movedX + movedZ * movedZ)) * 4.0f;
        if (totalMotion > 1.0f) {
            totalMotion = 1.0f;
        }
        this.field_70721_aZ += (totalMotion - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    static /* synthetic */ PathNavigator access$200(MeganeuropsisEntity x0) {
        return x0.field_70699_by;
    }

    private class EntityAIMeganeuropsisLand
    extends Goal {
        private final MeganeuropsisEntity taskOwner;
        private BlockPos landingPos = null;
        private Direction blockFace = null;
        private PlayerEntity landingPlayer = null;

        public EntityAIMeganeuropsisLand(MeganeuropsisEntity creature) {
            this.taskOwner = creature;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.TARGET));
        }

        public boolean func_75250_a() {
            if (this.taskOwner.func_70643_av() != null) {
                return false;
            }
            if (this.landingPos == null && this.landingPlayer == null && this.taskOwner.func_70681_au().nextFloat() <= 0.01f) {
                if (MeganeuropsisEntity.this.field_70146_Z.nextBoolean()) {
                    PlayerEntity nearestPlayer = this.taskOwner.field_70170_p.func_217366_a(MeganeuropsisEntity.this.func_226277_ct_(), MeganeuropsisEntity.this.func_226278_cu_(), MeganeuropsisEntity.this.func_226281_cx_(), 10.0, false);
                    if (nearestPlayer != null && !nearestPlayer.func_184207_aI()) {
                        this.taskOwner.field_70699_by.func_75499_g();
                        this.landingPlayer = nearestPlayer;
                        return true;
                    }
                } else {
                    for (int i = 0; i < 3; ++i) {
                        int x = (int)(this.taskOwner.func_226277_ct_() + this.taskOwner.func_70681_au().nextGaussian() * 10.0);
                        int z = (int)(this.taskOwner.func_226281_cx_() + this.taskOwner.func_70681_au().nextGaussian() * 10.0);
                        int y = this.taskOwner.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos((double)x, this.taskOwner.func_226278_cu_(), (double)z)).func_177956_o();
                        if (this.taskOwner.func_226278_cu_() - (double)y > 10.0) continue;
                        if ((double)y > this.taskOwner.func_226278_cu_()) {
                            return false;
                        }
                        this.taskOwner.field_70699_by.func_75499_g();
                        this.landingPos = new BlockPos(x, y, z);
                        this.blockFace = Direction.UP;
                        return true;
                    }
                }
            }
            return false;
        }

        public void func_75249_e() {
            if (this.landingPos != null) {
                this.taskOwner.func_70661_as().func_75492_a((double)this.landingPos.func_177958_n(), (double)(this.landingPos.func_177956_o() + 1), (double)this.landingPos.func_177952_p(), 1.0);
            } else if (this.landingPlayer != null) {
                this.taskOwner.func_70661_as().func_75497_a((Entity)this.landingPlayer, 1.0);
            }
        }

        public boolean func_75253_b() {
            if (this.landingPos == null && (this.landingPlayer == null || !this.landingPlayer.func_70089_S() || this.landingPlayer.func_184207_aI() && !this.landingPlayer.func_184196_w((Entity)this.taskOwner)) || this.taskOwner.func_70643_av() != null) {
                return false;
            }
            return !this.taskOwner.func_70661_as().func_75500_f() || this.taskOwner.getStartLandingTicks() > 0 && this.taskOwner.field_70173_aa - this.taskOwner.getStartLandingTicks() < 240;
        }

        public void func_75246_d() {
            BlockPos targetPos;
            BlockPos blockPos = targetPos = this.landingPos != null ? this.landingPos : this.landingPlayer.func_180425_c().func_177984_a();
            if (!this.taskOwner.isLanded()) {
                if (this.taskOwner.func_180425_c().func_218140_a((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), true) <= 4.0) {
                    this.taskOwner.func_70661_as().func_75499_g();
                    Vec3d actualLandingLocation = this.getActualLandingLocation();
                    BlockPos actualLandingBlockPos = new BlockPos(actualLandingLocation);
                    if (this.taskOwner.field_70170_p.func_180495_p(actualLandingBlockPos).func_196952_d((IBlockReader)this.taskOwner.field_70170_p, actualLandingBlockPos) != VoxelShapes.func_197880_a()) {
                        this.landingPos = null;
                        this.landingPlayer = null;
                        return;
                    }
                    if (this.taskOwner.getStartLandingTicks() == 0) {
                        this.taskOwner.field_70180_af.func_187227_b(START_LANDING_TICKS, (Object)this.taskOwner.field_70173_aa);
                    }
                    if (this.taskOwner.func_180425_c().func_218140_a((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), true) <= 1.0) {
                        double vecX = actualLandingLocation.field_72450_a - this.taskOwner.func_226277_ct_();
                        double vecZ = actualLandingLocation.field_72449_c - this.taskOwner.func_226281_cx_();
                        float rotYaw = (float)(MathHelper.func_181159_b((double)vecZ, (double)vecX) * 57.29577951308232) - 90.0f;
                        this.taskOwner.func_70012_b(actualLandingLocation.field_72450_a, actualLandingLocation.field_72448_b, actualLandingLocation.field_72449_c, rotYaw, 0.0f);
                        this.taskOwner.field_70180_af.func_187227_b(LANDED, (Object)true);
                        if (this.landingPlayer != null) {
                            this.taskOwner.field_70180_af.func_187227_b(LANDING_DIRECTION, (Object)Direction.DOWN);
                            this.taskOwner.field_70180_af.func_187227_b(LANDED_PLAYER, Optional.of(this.landingPlayer.func_110124_au()));
                            this.taskOwner.func_184205_a((Entity)this.landingPlayer, true);
                        } else {
                            this.taskOwner.field_70180_af.func_187227_b(LANDING_DIRECTION, (Object)this.blockFace);
                        }
                    } else {
                        double vecX = (actualLandingLocation.field_72450_a - this.taskOwner.func_226277_ct_()) * 0.5;
                        double vecZ = (actualLandingLocation.field_72449_c - this.taskOwner.func_226281_cx_()) * 0.5;
                        double vecY = (actualLandingLocation.field_72448_b - this.taskOwner.func_226278_cu_()) * 0.5;
                        this.taskOwner.func_213315_a(MoverType.SELF, new Vec3d(vecX, vecY, vecZ));
                    }
                }
            } else if (this.landingPlayer == null) {
                Vec3d actualLandingLocation = this.getActualLandingLocation();
                this.taskOwner.func_213317_d(new Vec3d(0.0, 0.0, 0.0));
                this.taskOwner.field_70133_I = true;
                this.taskOwner.func_70634_a(actualLandingLocation.field_72450_a, actualLandingLocation.field_72448_b - 0.5, actualLandingLocation.field_72449_c);
            }
        }

        public void func_75251_c() {
            this.landingPos = null;
            this.blockFace = null;
            this.landingPlayer = null;
            this.taskOwner.field_70180_af.func_187227_b(START_LANDING_TICKS, (Object)0);
            this.taskOwner.field_70180_af.func_187227_b(LANDED, (Object)false);
            this.taskOwner.field_70180_af.func_187227_b(LANDING_DIRECTION, (Object)Direction.DOWN);
            this.taskOwner.field_70180_af.func_187227_b(LANDED_PLAYER, Optional.empty());
            this.taskOwner.func_184210_p();
        }

        private Vec3d getActualLandingLocation() {
            if (this.landingPlayer != null) {
                return new Vec3d(this.landingPlayer.func_226277_ct_(), this.landingPlayer.func_226278_cu_() + (double)this.landingPlayer.func_213302_cg() + (double)this.taskOwner.func_213302_cg() + 0.1, this.landingPlayer.func_226281_cx_());
            }
            switch (this.blockFace) {
                case NORTH: {
                    return new Vec3d((double)this.landingPos.func_177958_n() + 0.5, (double)this.landingPos.func_177956_o() + 0.5, (double)this.landingPos.func_177952_p() - (double)this.taskOwner.func_213311_cf() / 2.0);
                }
                case SOUTH: {
                    return new Vec3d((double)this.landingPos.func_177958_n() + 0.5, (double)this.landingPos.func_177956_o() + 0.5, (double)(this.landingPos.func_177952_p() + 1) + (double)this.taskOwner.func_213311_cf() / 2.0);
                }
                case EAST: {
                    return new Vec3d((double)(this.landingPos.func_177958_n() + 1) + (double)this.taskOwner.func_213311_cf() / 2.0, (double)this.landingPos.func_177956_o() + 0.5, (double)this.landingPos.func_177952_p() + 0.5);
                }
                case WEST: {
                    return new Vec3d((double)this.landingPos.func_177958_n() - (double)this.taskOwner.func_213311_cf() / 2.0, (double)this.landingPos.func_177956_o() + 0.5, (double)this.landingPos.func_177952_p() + 0.5);
                }
            }
            return new Vec3d((double)this.landingPos.func_177958_n() + 0.5, (double)this.landingPos.func_177956_o() + 0.5, (double)this.landingPos.func_177952_p() + 0.5);
        }
    }
}

