/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.animal;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.ai.mob.CompletePanicGoal;
import net.tslat.aoa3.entity.base.AoAAnimal;
import net.tslat.aoa3.util.EntityUtil;

public class ShikEntity
extends AoAAnimal {
    private static final DataParameter<Boolean> SCARED = EntityDataManager.func_187226_a(ShikEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DANCING = EntityDataManager.func_187226_a(ShikEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private ShikEntity dancePartner = null;

    public ShikEntity(EntityType<? extends AnimalEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCARED, (Object)false);
        this.field_70180_af.func_187214_a(DANCING, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicAndHideGoal(this, 100, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new ShikDanceGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 0.34375f;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 5.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2;
    }

    @Override
    protected double getBaseArmor() {
        return 4.0;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)AoASounds.ENTITY_SHIK_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_SHIK_DEATH.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    public boolean isScared() {
        return (Boolean)this.field_70180_af.func_187225_a(SCARED);
    }

    public boolean isDancing() {
        return (Boolean)this.field_70180_af.func_187225_a(DANCING);
    }

    @Override
    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        if (!EntityUtil.isNaturalSpawnReason(reason)) {
            return true;
        }
        if (this.func_226278_cu_() >= 120.0) {
            return false;
        }
        BlockPos checkPos = new BlockPos((Entity)this);
        BlockState spawnBlock = world.func_180495_p(checkPos.func_177977_b());
        return spawnBlock.func_177230_c() == AoABlocks.DENSE_STONE.get();
    }

    @Override
    protected int getSpawnChanceFactor() {
        return 500;
    }

    public float func_205022_a(BlockPos pos, IWorldReader world) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(Tags.Blocks.STONE) ? 1.0f : 1.0f - world.func_205052_D(pos);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.field_70173_aa > 400;
    }

    @Override
    protected boolean checkSpawningLightConditions() {
        return true;
    }

    public class PanicAndHideGoal
    extends CompletePanicGoal {
        private BlockPos hidePos;

        public PanicAndHideGoal(ShikEntity shik, int timeToPanic, double speed) {
            super((CreatureEntity)shik, timeToPanic, speed);
        }

        @Override
        public boolean func_75250_a() {
            if (this.taskOwner.func_70681_au().nextFloat() <= 0.1f && !ShikEntity.this.field_70170_p.func_175674_a((Entity)this.taskOwner, this.taskOwner.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0), entity -> entity != null && entity.func_200600_R() != this.taskOwner.func_200600_R()).isEmpty()) {
                return this.getRandomPosition();
            }
            return super.func_75250_a();
        }

        @Override
        public void func_75251_c() {
            this.taskOwner.field_70145_X = false;
            ((ShikEntity)this.taskOwner).field_70180_af.func_187227_b(SCARED, (Object)false);
            super.func_75251_c();
        }

        @Override
        public void func_75249_e() {
            ((ShikEntity)this.taskOwner).field_70180_af.func_187227_b(SCARED, (Object)true);
            super.func_75249_e();
        }

        @Override
        public void func_75246_d() {
            if (this.taskOwner.func_70681_au().nextFloat() < 0.1f) {
                int z;
                int x;
                BlockPos.Mutable checkPos;
                if (this.hidePos != null) {
                    if (this.hidePos.func_218140_a(this.taskOwner.func_226277_ct_(), this.taskOwner.func_226278_cu_(), this.taskOwner.func_226281_cx_(), true) < 3.0) {
                        ShikEntity.this.func_70106_y();
                        return;
                    }
                    if (this.taskOwner.func_70661_as().func_75500_f()) {
                        checkPos = new BlockPos.Mutable();
                        for (x = -1; x <= 1; ++x) {
                            for (z = -1; z <= 1; ++z) {
                                if (this.taskOwner.field_70170_p.func_180495_p((BlockPos)checkPos.func_189532_c(this.taskOwner.func_226277_ct_() + (double)(-x), this.taskOwner.func_226278_cu_(), this.taskOwner.func_226281_cx_() + (double)(-z))).func_177230_c() != AoABlocks.DENSE_STONE.get()) continue;
                                ShikEntity.this.func_70106_y();
                                return;
                            }
                        }
                    }
                }
                if (this.hidePos == null && this.taskOwner.func_70681_au().nextFloat() < 0.1f) {
                    checkPos = new BlockPos.Mutable();
                    for (x = 0; x <= 3; ++x) {
                        for (z = 0; z <= 3; ++z) {
                            if (this.taskOwner.field_70170_p.func_180495_p((BlockPos)checkPos.func_189532_c(this.taskOwner.func_226277_ct_() + (double)x, this.taskOwner.func_226278_cu_(), this.taskOwner.func_226281_cx_() + (double)z)).func_177230_c() == AoABlocks.DENSE_STONE.get()) {
                                ShikEntity.this.func_70661_as().func_75492_a((double)checkPos.func_177958_n() + 0.5, (double)checkPos.func_177956_o(), (double)checkPos.func_177952_p() + 0.5, this.speed);
                                ++this.panicTimer;
                                this.hidePos = checkPos.func_185334_h();
                                return;
                            }
                            if (this.taskOwner.field_70170_p.func_180495_p((BlockPos)checkPos.func_189532_c(this.taskOwner.func_226277_ct_() + (double)(-x), this.taskOwner.func_226278_cu_(), this.taskOwner.func_226281_cx_() + (double)(-z))).func_177230_c() != AoABlocks.DENSE_STONE.get()) continue;
                            this.taskOwner.func_70661_as().func_75492_a((double)checkPos.func_177958_n() + 0.5, (double)checkPos.func_177956_o(), (double)checkPos.func_177952_p() + 0.5, this.speed);
                            ++this.panicTimer;
                            this.hidePos = checkPos.func_185334_h();
                            return;
                        }
                    }
                }
            }
            super.func_75246_d();
        }
    }

    private class ShikDanceGoal
    extends Goal {
        private final ShikEntity shik;
        private Vec3d startPos;
        private int danceTimer = 0;
        private int nextDanceTime = 0;
        private float danceAngleX;
        private float danceAngleZ;

        private ShikDanceGoal(ShikEntity shik) {
            this.shik = shik;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.nextDanceTime + 100 >= this.shik.field_70173_aa) {
                return false;
            }
            if (this.shik.dancePartner != null && this.shik.dancePartner.func_70089_S()) {
                return true;
            }
            if (ShikEntity.this.field_70146_Z.nextFloat() <= 0.05f) {
                List dancePartners = ShikEntity.this.field_70170_p.func_217357_a(ShikEntity.class, ShikEntity.this.func_174813_aQ().func_186662_g(0.5));
                for (ShikEntity potentialPartner : dancePartners) {
                    if (potentialPartner == this.shik || potentialPartner.isScared() || !potentialPartner.func_70089_S() || potentialPartner.dancePartner != null || !potentialPartner.func_70685_l((Entity)this.shik) || !this.shik.func_70685_l((Entity)potentialPartner)) continue;
                    this.shik.dancePartner = potentialPartner;
                    potentialPartner.dancePartner = this.shik;
                    return true;
                }
            }
            return false;
        }

        public void func_75251_c() {
            this.shik.field_70180_af.func_187227_b(DANCING, (Object)false);
            this.startPos = null;
            this.danceTimer = 0;
            this.shik.func_70661_as().func_75499_g();
            this.nextDanceTime = ShikEntity.this.field_70173_aa;
            this.shik.dancePartner = null;
        }

        public void func_75249_e() {
            ShikEntity.this.func_70661_as().func_75499_g();
            this.startPos = ShikEntity.this.func_174791_d();
            this.shik.field_70180_af.func_187227_b(DANCING, (Object)true);
            this.shik.func_70671_ap().func_75650_a(this.shik.dancePartner.func_226277_ct_(), this.shik.dancePartner.func_226278_cu_() + (double)this.shik.dancePartner.func_70047_e(), this.shik.dancePartner.func_226281_cx_(), (float)this.shik.dancePartner.func_184649_cE(), (float)this.shik.dancePartner.func_70646_bf());
            this.danceAngleX = MathHelper.func_76126_a((float)(this.shik.field_70177_z * (float)Math.PI / 180.0f)) * 2.0f;
            this.danceAngleZ = MathHelper.func_76134_b((float)(this.shik.field_70177_z * (float)Math.PI / 180.0f)) * 2.0f;
            ShikEntity.this.func_70661_as().func_75492_a(this.startPos.field_72450_a + (double)(this.danceAngleX * 5.0f), this.startPos.field_72448_b, this.startPos.field_72449_c + (double)(this.danceAngleZ * 5.0f), 1.25);
        }

        public void func_75246_d() {
            ++this.danceTimer;
            this.shik.func_70671_ap().func_75650_a(this.shik.dancePartner.func_226277_ct_(), this.shik.dancePartner.func_226278_cu_() + (double)this.shik.dancePartner.func_70047_e(), this.shik.dancePartner.func_226281_cx_(), (float)this.shik.dancePartner.func_184649_cE(), (float)this.shik.dancePartner.func_70646_bf());
            this.shik.func_70101_b(this.shik.field_70759_as, this.shik.field_70125_A);
            if (this.danceTimer % 10 == 0 || ShikEntity.this.func_70661_as().func_75500_f()) {
                this.danceAngleX *= -1.0f;
                this.danceAngleZ *= -1.0f;
                this.shik.func_70661_as().func_75499_g();
                this.shik.func_70661_as().func_75492_a(this.startPos.field_72450_a + (double)(this.danceAngleX * 5.0f), this.startPos.field_72448_b, this.startPos.field_72449_c + (double)(this.danceAngleZ * 5.0f), 1.25);
            }
        }

        public boolean func_75253_b() {
            return this.shik.dancePartner != null && this.startPos != null && this.shik.dancePartner.func_70089_S() && this.danceTimer < 100;
        }
    }
}

