/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class AoAAmbientNPC
extends CreatureEntity
implements INPC {
    public AoAAmbientNPC(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, AoAMeleeMob.class, 8.0f, 0.8, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected abstract double getBaseMaxHealth();

    protected abstract double getBaseMovementSpeed();

    @Nullable
    protected abstract String getInteractMessage(ItemStack var1);

    protected boolean isFixedTradesList() {
        return false;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return this.checkSpawnChance(reason) && this.isValidLightLevel(reason) && this.canSpawnAt(reason, world.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean canSpawnAt(SpawnReason reason, BlockState blockState) {
        return reason == SpawnReason.SPAWNER || blockState.func_215688_a((IBlockReader)this.field_70170_p, this.func_180425_c(), this.func_200600_R());
    }

    protected int getSpawnChanceFactor() {
        return 1;
    }

    private boolean checkSpawnChance(SpawnReason reason) {
        return EntityUtil.isNaturalSpawnReason(reason) || this.getSpawnChanceFactor() <= 1 || this.field_70146_Z.nextInt(this.getSpawnChanceFactor()) == 0;
    }

    protected boolean isValidLightLevel(SpawnReason reason) {
        if (this.field_70170_p.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return true;
        }
        BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b, this.func_226281_cx_());
        if (this.field_70170_p.func_226658_a_(LightType.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return true;
        }
        int light = this.field_70170_p.func_72911_I() ? this.field_70170_p.func_205049_d(blockpos, 10) : (int)this.field_70170_p.func_205052_D(blockpos) * 15;
        return light > this.field_70146_Z.nextInt(8);
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        String msg;
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == Items.field_151057_cb) {
            heldStack.func_111282_a(player, (LivingEntity)this, hand);
            return true;
        }
        if (!this.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND && (msg = this.getInteractMessage(heldStack)) != null) {
            PlayerUtil.notifyPlayer((ServerPlayerEntity)player, msg, TextFormatting.GRAY);
        }
        return super.func_184645_a(player, hand);
    }
}

