/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.util.EntityUtil;

public abstract class AoAAnimal
extends AnimalEntity {
    public AoAAnimal(EntityType<? extends AnimalEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = (int)this.getBaseMaxHealth() / 25;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        if (this.isBreedable()) {
            this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
            if (this.getTemptItem() != null) {
                this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.getTemptItem()}), false));
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.getBaseArmor());
    }

    protected abstract double getBaseMaxHealth();

    protected abstract double getBaseMovementSpeed();

    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    protected double getBaseArmor() {
        return 0.0;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return SoundEvents.field_187566_ao;
    }

    public static boolean meetsSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return true;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        if (!EntityUtil.isNaturalSpawnReason(reason)) {
            return true;
        }
        BlockPos checkPos = new BlockPos((Entity)this);
        BlockState spawnBlock = world.func_180495_p(checkPos.func_177977_b());
        return (spawnBlock.func_203425_a(Tags.Blocks.DIRT) || spawnBlock.func_203425_a(Tags.Blocks.STONE) || spawnBlock.func_203425_a(AoATags.Blocks.GRASS)) && this.checkSpawningLightConditions();
    }

    protected int getSpawnChanceFactor() {
        return 1;
    }

    private boolean checkSpawnChance() {
        return this.getSpawnChanceFactor() <= 1 || this.field_70146_Z.nextInt(this.getSpawnChanceFactor()) == 0;
    }

    protected boolean checkSpawningLightConditions() {
        return this.field_70170_p.func_205052_D(this.func_180425_c()) > 0.5f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == this.getTemptItem();
    }

    protected boolean isBreedable() {
        return false;
    }

    @Nullable
    protected Item getTemptItem() {
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        if (this.getStepSound(pos, block) != null) {
            this.func_184185_a(this.getStepSound(pos, block), 0.55f, 1.0f);
        }
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity partner) {
        return null;
    }
}

