/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.ai.mob.FlyingLookRandomlyGoal;
import net.tslat.aoa3.entity.ai.mob.FlyingMeleeAttackGoal;
import net.tslat.aoa3.entity.ai.mob.RandomFlyingGoal;
import net.tslat.aoa3.entity.ai.movehelper.RoamingFlightMoveHelper;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class AoAFlyingMeleeMob
extends FlyingEntity
implements IMob {
    protected boolean isSlipperyMovement = false;

    protected AoAFlyingMeleeMob(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new RoamingFlightMoveHelper((MobEntity)this);
        this.field_70728_aV = (int)(5.0 + (this.getBaseMaxHealth() + this.getBaseArmour() * 1.75 + this.getBaseMeleeDamage() * 2.0) / 10.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomFlyingGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyingLookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FlyingMeleeAttackGoal(this, 0.6f, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AoAMinion.class, 10, true, true, entity -> entity instanceof AoAMinion && ((AoAMinion)((Object)entity)).func_70909_n()));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, true, pl -> pl instanceof PlayerEntity && PlayerUtil.shouldPlayerBeAffected((PlayerEntity)pl)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getBaseMeleeDamage() * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.5f : 1.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth() * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 2.0f : 1.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.getBaseArmour() * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.25f : 1.0f));
    }

    protected PathNavigator func_175447_b(World world) {
        return new FlyingPathNavigator((MobEntity)this, world);
    }

    protected abstract float func_213348_b(Pose var1, EntitySize var2);

    protected abstract double getBaseKnockbackResistance();

    protected abstract double getBaseMaxHealth();

    protected abstract double getBaseMeleeDamage();

    protected abstract double getBaseMovementSpeed();

    protected double getBaseArmour() {
        return 0.0;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    protected boolean isOverworldMob() {
        return false;
    }

    protected boolean isDaylightMob() {
        return false;
    }

    protected int getMinSpawnHeight() {
        return 0;
    }

    protected int getMaxSpawnHeight() {
        return 255;
    }

    @Nullable
    protected OverworldEvents.Event getEventRequirement() {
        return null;
    }

    protected void onAttack(Entity target) {
    }

    protected void onHit(DamageSource source, float amount) {
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onAttack(target);
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            this.onHit(source, amount);
            return true;
        }
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public static boolean meetsSpawnConditions(EntityType<? extends MonsterEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return this.checkWorldRequirements(reason) && this.isValidLightLevel(reason) && this.canSpawnAt(reason, world.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean canSpawnAt(SpawnReason reason, BlockState blockState) {
        if (EntityUtil.isNaturalSpawnReason(reason) && (this.func_226278_cu_() > (double)this.getMaxSpawnHeight() || this.func_226278_cu_() < (double)this.getMinSpawnHeight())) {
            return false;
        }
        return blockState.func_215688_a((IBlockReader)this.field_70170_p, this.func_180425_c(), this.func_200600_R());
    }

    private boolean isValidLightLevel(SpawnReason reason) {
        if (this.isDaylightMob() && !this.field_70170_p.func_72935_r()) {
            return false;
        }
        if (this.isDaylightMob() || !this.isOverworldMob()) {
            return WorldUtil.getLightLevel(this.field_70170_p, this.func_180425_c(), true, false) <= RandomUtil.randomNumberUpTo(8);
        }
        if (this.field_70170_p.func_226658_a_(LightType.SKY, this.func_180425_c()) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int light = this.field_70170_p.func_72911_I() ? this.field_70170_p.func_205049_d(this.func_180425_c(), 10) : (int)this.field_70170_p.func_205052_D(this.func_180425_c()) * 15;
        return light <= this.field_70146_Z.nextInt(8);
    }

    private boolean checkWorldRequirements(SpawnReason reason) {
        if (this.isOverworldMob() && this.field_70170_p.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        OverworldEvents.Event eventReq = this.getEventRequirement();
        return eventReq == null || OverworldEvents.isEventActive(eventReq);
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }
}

