/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.ai.mob.FlyingLookRandomlyGoal;
import net.tslat.aoa3.entity.ai.mob.FlyingRangedAttackGoal;
import net.tslat.aoa3.entity.ai.mob.RandomFlyingGoal;
import net.tslat.aoa3.entity.ai.movehelper.RoamingFlightMoveHelper;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class AoAFlyingRangedMob
extends FlyingEntity
implements IMob,
IRangedAttackMob,
AoARangedAttacker {
    protected boolean isSlipperyMovement = false;

    protected AoAFlyingRangedMob(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new RoamingFlightMoveHelper((MobEntity)this);
        this.field_70728_aV = (int)(5.0 + (this.getBaseMaxHealth() + this.getBaseArmour() * 1.75 + this.getBaseProjectileDamage() * 2.0) / 10.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomFlyingGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyingLookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FlyingRangedAttackGoal(this, 40, 80));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AoAMinion.class, 10, true, true, entity -> entity instanceof AoAMinion && ((AoAMinion)((Object)entity)).func_70909_n()));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, true, pl -> pl instanceof PlayerEntity && PlayerUtil.shouldPlayerBeAffected((PlayerEntity)pl)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth() * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 2.0f : 1.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.getBaseArmour() * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.25f : 1.0f));
    }

    protected PathNavigator func_175447_b(World world) {
        return new FlyingPathNavigator((MobEntity)this, world);
    }

    protected abstract float func_213348_b(Pose var1, EntitySize var2);

    protected abstract double getBaseKnockbackResistance();

    protected abstract double getBaseMaxHealth();

    public abstract double getBaseProjectileDamage();

    protected abstract double getBaseMovementSpeed();

    protected double getBaseArmour() {
        return 0.0;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nullable
    protected abstract SoundEvent getShootSound();

    protected boolean isOverworldMob() {
        return false;
    }

    protected boolean isDaylightMob() {
        return false;
    }

    protected int getMinSpawnHeight() {
        return 0;
    }

    protected int getMaxSpawnHeight() {
        return 255;
    }

    @Nullable
    protected OverworldEvents.Event getEventRequirement() {
        return null;
    }

    protected void onHit(DamageSource source, float amount) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            this.onHit(source, amount);
            return true;
        }
        return false;
    }

    public void func_82196_d(@Nonnull LivingEntity target, float bowDamageFactor) {
        BaseMobProjectile projectile = this.getNewProjectileInstance();
        double distanceFactorX = target.func_226277_ct_() - projectile.func_226277_ct_();
        double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - projectile.func_226278_cu_();
        double distanceFactorZ = target.func_226281_cx_() - projectile.func_226281_cx_();
        double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
        if (this.getShootSound() != null) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getShootSound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        this.field_70170_p.func_217376_c((Entity)projectile);
    }

    protected abstract BaseMobProjectile getNewProjectileInstance();

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        boolean success;
        float mod = (Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.5f : 1.0f;
        switch (projectile.getProjectileType()) {
            case MAGIC: {
                success = DamageUtil.dealMagicDamage((Entity)projectile, (LivingEntity)this, target, (float)this.getBaseProjectileDamage() * mod, false);
                break;
            }
            case GUN: {
                success = DamageUtil.dealGunDamage(target, (LivingEntity)this, projectile, (float)this.getBaseProjectileDamage() * mod);
                break;
            }
            case PHYSICAL: {
                success = DamageUtil.dealRangedDamage(target, (LivingEntity)this, (Entity)projectile, (float)this.getBaseProjectileDamage() * mod);
                break;
            }
            default: {
                success = target.func_70097_a(DamageSource.func_188403_a((Entity)projectile, (LivingEntity)this), (float)this.getBaseProjectileDamage() * mod);
            }
        }
        if (success) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d() && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public boolean func_145773_az() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public static boolean meetsSpawnConditions(EntityType<? extends MonsterEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return this.checkWorldRequirements(reason) && this.isValidLightLevel(reason) && this.canSpawnAt(reason, world.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean canSpawnAt(SpawnReason reason, BlockState blockState) {
        if (EntityUtil.isNaturalSpawnReason(reason) && (this.func_226278_cu_() > (double)this.getMaxSpawnHeight() || this.func_226278_cu_() < (double)this.getMinSpawnHeight())) {
            return false;
        }
        return blockState.func_215688_a((IBlockReader)this.field_70170_p, this.func_180425_c(), this.func_200600_R());
    }

    private boolean isValidLightLevel(SpawnReason reason) {
        if (this.isDaylightMob() && !this.field_70170_p.func_72935_r()) {
            return false;
        }
        if (this.isDaylightMob() || !this.isOverworldMob()) {
            return WorldUtil.getLightLevel(this.field_70170_p, this.func_180425_c(), true, false) <= RandomUtil.randomNumberUpTo(8);
        }
        if (this.field_70170_p.func_226658_a_(LightType.SKY, this.func_180425_c()) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int light = this.field_70170_p.func_72911_I() ? this.field_70170_p.func_205049_d(this.func_180425_c(), 10) : (int)this.field_70170_p.func_205052_D(this.func_180425_c()) * 15;
        return light <= this.field_70146_Z.nextInt(8);
    }

    private boolean checkWorldRequirements(SpawnReason reason) {
        if (this.isOverworldMob() && this.field_70170_p.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        OverworldEvents.Event eventReq = this.getEventRequirement();
        return eventReq == null || OverworldEvents.isEventActive(eventReq);
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }
}

