/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public abstract class AoARangedMob
extends MonsterEntity
implements IRangedAttackMob,
AoARangedAttacker {
    protected boolean isSlipperyMovement = false;

    protected AoARangedMob(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = (int)(5.0 + (this.getBaseMaxHealth() + this.getBaseArmour() * 1.75 + this.getBaseProjectileDamage() * 2.0) / 10.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 20, 40, 32.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AoAMinion.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth() * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 2.0f : 1.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.getBaseArmour() * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.25f : 1.0f));
    }

    protected abstract float func_213348_b(Pose var1, EntitySize var2);

    protected abstract double getBaseKnockbackResistance();

    protected abstract double getBaseMaxHealth();

    public abstract double getBaseProjectileDamage();

    protected abstract double getBaseMovementSpeed();

    protected double getBaseArmour() {
        return 0.0;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nullable
    protected abstract SoundEvent getShootSound();

    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return SoundEvents.field_187709_dP;
    }

    protected boolean isOverworldMob() {
        return false;
    }

    protected boolean isDaylightMob() {
        return false;
    }

    protected int getMinSpawnHeight() {
        return 0;
    }

    protected int getMaxSpawnHeight() {
        return 255;
    }

    @Nullable
    protected OverworldEvents.Event getEventRequirement() {
        return null;
    }

    protected abstract BaseMobProjectile getNewProjectileInstance();

    protected void onAttack(Entity target) {
    }

    protected void onHit(DamageSource source, float amount) {
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onAttack(target);
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            this.onHit(source, amount);
            return true;
        }
        return false;
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        boolean success;
        float mod = (Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.5f : 1.0f;
        switch (projectile.getProjectileType()) {
            case MAGIC: {
                success = DamageUtil.dealMagicDamage((Entity)projectile, (LivingEntity)this, target, (float)this.getBaseProjectileDamage() * mod, false);
                break;
            }
            case GUN: {
                success = DamageUtil.dealGunDamage(target, (LivingEntity)this, projectile, (float)this.getBaseProjectileDamage() * mod);
                break;
            }
            case PHYSICAL: {
                success = DamageUtil.dealRangedDamage(target, (LivingEntity)this, (Entity)projectile, (float)this.getBaseProjectileDamage() * mod);
                break;
            }
            default: {
                success = target.func_70097_a(DamageSource.func_188403_a((Entity)projectile, (LivingEntity)this), (float)this.getBaseProjectileDamage() * mod);
            }
        }
        if (success) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        BaseMobProjectile projectile = this.getNewProjectileInstance();
        double distanceFactorX = target.func_226277_ct_() - this.func_226277_ct_();
        double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - projectile.func_226278_cu_();
        double distanceFactorZ = target.func_226281_cx_() - this.func_226281_cx_();
        double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) + 0.2;
        if (this.getShootSound() != null) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getShootSound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        this.field_70170_p.func_217376_c((Entity)projectile);
    }

    public void func_213352_e(Vec3d motionVec) {
        double travelledZ;
        if (this.func_70613_aW() || this.func_184186_bw()) {
            Vec3d currentMotion;
            boolean falling;
            IAttributeInstance gravity = this.func_110148_a(ENTITY_GRAVITY);
            boolean bl = falling = this.func_213322_ci().field_72448_b <= 0.0;
            if (falling && this.func_70644_a(Effects.field_204839_B)) {
                if (!gravity.func_180374_a(EntityUtil.SLOW_FALLING)) {
                    gravity.func_111121_a(EntityUtil.SLOW_FALLING);
                }
                this.field_70143_R = 0.0f;
            } else if (gravity.func_180374_a(EntityUtil.SLOW_FALLING)) {
                gravity.func_111124_b(EntityUtil.SLOW_FALLING);
            }
            double gravityValue = gravity.func_111126_e();
            if (!this.func_70090_H()) {
                if (!this.func_180799_ab()) {
                    float moveFactor;
                    BlockPos feetPos = this.func_226270_aj_();
                    float blockSlip = this.field_70170_p.func_180495_p(feetPos).getSlipperiness((IWorldReader)this.field_70170_p, feetPos, (Entity)this);
                    float friction = this.field_70122_E ? blockSlip * 0.91f : 0.91f;
                    float f = moveFactor = this.field_70122_E ? this.func_70689_ay() * (0.21600002f / (blockSlip * blockSlip * blockSlip)) : this.field_70747_aH;
                    if (this.isSlipperyMovement) {
                        friction = (float)((double)friction * 0.9);
                    }
                    this.func_213309_a(moveFactor, motionVec);
                    currentMotion = this.func_213322_ci();
                    if (this.func_70617_f_()) {
                        this.field_70143_R = 0.0f;
                        currentMotion = new Vec3d(MathHelper.func_151237_a((double)currentMotion.field_72450_a, (double)-0.15f, (double)0.15f), Math.max(currentMotion.field_72448_b, (double)-0.15f), MathHelper.func_151237_a((double)currentMotion.field_72449_c, (double)-0.15f, (double)0.15f));
                    }
                    this.func_213317_d(currentMotion);
                    this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                    currentMotion = this.func_213322_ci();
                    if ((this.field_70123_F || this.field_70703_bu) && this.func_70617_f_()) {
                        currentMotion = new Vec3d(currentMotion.field_72450_a, 0.2, currentMotion.field_72449_c);
                    }
                    double yVelocity = currentMotion.field_72448_b;
                    if (this.func_70644_a(Effects.field_188424_y)) {
                        yVelocity += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - currentMotion.field_72448_b) * 0.2;
                        this.field_70143_R = 0.0f;
                    } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(feetPos)) {
                        yVelocity = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
                    } else if (!this.func_189652_ae()) {
                        yVelocity -= gravityValue;
                    }
                    this.func_213293_j(currentMotion.field_72450_a * (double)friction, yVelocity * (double)0.98f, currentMotion.field_72449_c * (double)friction);
                } else {
                    this.func_213309_a(0.02f, motionVec);
                    this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
                    if (!this.func_189652_ae()) {
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -gravityValue / 4.0, 0.0));
                    }
                    currentMotion = this.func_213322_ci();
                    if (this.field_70123_F && this.func_70038_c(currentMotion.field_72450_a, currentMotion.field_72448_b + (double)0.6f - this.func_226278_cu_() + this.func_226278_cu_(), currentMotion.field_72449_c)) {
                        this.func_213293_j(currentMotion.field_72450_a, 0.3f, currentMotion.field_72449_c);
                    }
                }
            } else {
                float drag = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float swimSpeed = 0.02f;
                float depthStrider = EnchantmentHelper.func_185294_d((LivingEntity)this);
                if (depthStrider > 3.0f) {
                    depthStrider = 3.0f;
                }
                if (!this.field_70122_E) {
                    depthStrider *= 0.5f;
                }
                if (depthStrider > 0.0f) {
                    drag += (0.54600006f - drag) * depthStrider / 3.0f;
                    swimSpeed += (this.func_70689_ay() - swimSpeed) * depthStrider / 3.0f;
                }
                if (this.func_70644_a(Effects.field_206827_D)) {
                    drag = 0.96f;
                }
                this.func_213309_a(swimSpeed *= (float)this.func_110148_a(SWIM_SPEED).func_111126_e(), motionVec);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                currentMotion = this.func_213322_ci();
                if (this.field_70123_F && this.func_70617_f_()) {
                    currentMotion = new Vec3d(currentMotion.field_72450_a, 0.2, currentMotion.field_72449_c);
                }
                this.func_213317_d(currentMotion.func_216372_d((double)drag, (double)0.8f, (double)drag));
                if (!this.func_189652_ae() && !this.func_70051_ag()) {
                    currentMotion = this.func_213322_ci();
                    double motionY = falling && Math.abs(currentMotion.field_72448_b - 0.005) >= 0.003 && Math.abs(currentMotion.field_72448_b - gravityValue / 16.0) < 0.003 ? -0.003 : currentMotion.field_72448_b - gravityValue / 16.0;
                    this.func_213293_j(currentMotion.field_72450_a, motionY, currentMotion.field_72449_c);
                }
                currentMotion = this.func_213322_ci();
                if (this.field_70123_F && this.func_70038_c(currentMotion.field_72450_a, currentMotion.field_72448_b + (double)0.6f - this.func_226278_cu_() + this.func_226278_cu_(), currentMotion.field_72449_c)) {
                    this.func_213293_j(currentMotion.field_72450_a, 0.3f, currentMotion.field_72449_c);
                }
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double travelledX = this.func_226277_ct_() - this.field_70169_q;
        float travel = MathHelper.func_76133_a((double)(travelledX * travelledX + (travelledZ = this.func_226281_cx_() - this.field_70166_s) * travelledZ)) * 4.0f;
        if (travel > 1.0f) {
            travel = 1.0f;
        }
        this.field_70721_aZ += (travel - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public static boolean meetsSpawnConditions(EntityType<? extends MonsterEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return this.checkWorldRequirements(reason) && this.isValidLightLevel(reason) && this.canSpawnAt(reason, world.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean canSpawnAt(SpawnReason reason, BlockState blockState) {
        if (EntityUtil.isNaturalSpawnReason(reason) && (this.func_226278_cu_() > (double)this.getMaxSpawnHeight() || this.func_226278_cu_() < (double)this.getMinSpawnHeight())) {
            return false;
        }
        return blockState.func_215688_a((IBlockReader)this.field_70170_p, this.func_180425_c(), this.func_200600_R());
    }

    private boolean isValidLightLevel(SpawnReason reason) {
        if (this.isDaylightMob() && !this.field_70170_p.func_72935_r()) {
            return false;
        }
        if (this.isDaylightMob() || !this.isOverworldMob()) {
            return WorldUtil.getLightLevel(this.field_70170_p, this.func_180425_c(), true, false) <= RandomUtil.randomNumberUpTo(8);
        }
        return AoARangedMob.func_223323_a((IWorld)this.field_70170_p, (BlockPos)this.func_180425_c(), (Random)this.field_70146_Z);
    }

    private boolean checkWorldRequirements(SpawnReason reason) {
        if (this.isOverworldMob() && this.field_70170_p.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        OverworldEvents.Event eventReq = this.getEventRequirement();
        return eventReq == null || OverworldEvents.isEventActive(eventReq);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        SoundEvent stepSound = this.getStepSound(pos, blockIn);
        if (stepSound != null) {
            this.func_184185_a(stepSound, 0.15f, 1.0f);
        }
    }
}

