/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.tslat.aoa3.common.registration.AoAEntitySpawns;
import net.tslat.aoa3.entity.ai.trader.TraderFaceCustomerGoal;
import net.tslat.aoa3.entity.ai.trader.TraderPlayerTradeGoal;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.npc.AoATraderRecipe;
import net.tslat.aoa3.util.EntityUtil;

public abstract class AoATrader
extends CreatureEntity
implements INPC,
IMerchant {
    private static final DataParameter<String> TRADE_STATUSES = EntityDataManager.func_187226_a(AoATrader.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> ADDITIONAL_TRADES = EntityDataManager.func_187226_a(AoATrader.class, (IDataSerializer)DataSerializers.field_187192_b);
    private MerchantOffers trades;
    private int maxTradesCount = 0;
    private String currentTradesInfo = "";
    private int additionalTrades = 0;
    private PlayerEntity latestCustomer;

    public AoATrader(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, AoAMeleeMob.class, 8.0f, 0.8, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new TraderPlayerTradeGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TraderFaceCustomerGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRADE_STATUSES, (Object)"");
        this.field_70180_af.func_187214_a(ADDITIONAL_TRADES, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected abstract double getBaseMaxHealth();

    protected abstract double getBaseMovementSpeed();

    protected boolean isFixedTradesList() {
        return false;
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public void func_213703_a(@Nullable MerchantOffers offers) {
        this.trades = offers;
    }

    public void func_213702_q(int xpIn) {
    }

    public int func_213708_dV() {
        return 0;
    }

    public SoundEvent func_213714_ea() {
        return null;
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.latestCustomer = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.latestCustomer;
    }

    public boolean isTrading() {
        return this.latestCustomer != null;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return this.checkSpawnChance(reason) && this.checkWorldRequirements(reason) && this.isValidLightLevel(reason) && this.canSpawnAt(reason, world.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean canSpawnAt(SpawnReason reason, BlockState blockState) {
        return reason == SpawnReason.SPAWNER || blockState.func_215688_a((IBlockReader)this.field_70170_p, this.func_180425_c(), this.func_200600_R());
    }

    protected boolean checkWorldRequirements(SpawnReason reason) {
        if (this.isOverworldNPC() && this.field_70170_p.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            AoAEntitySpawns.removeSpawn(this.func_200600_R(), this.field_70170_p.func_226691_t_(this.func_180425_c()));
            return false;
        }
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isOverworldNPC() || this.field_70170_p.field_73011_w.func_186058_p() != DimensionType.field_223227_a_ || this.field_70173_aa >= 72000;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("TradeStatuses", this.currentTradesInfo);
        compound.func_74768_a("AdditionalTrades", this.additionalTrades);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.currentTradesInfo = compound.func_74764_b("TradeStatuses") ? compound.func_74779_i("TradeStatuses") : "";
        int n = this.additionalTrades = compound.func_74764_b("AdditionalTrades") ? compound.func_74762_e("AdditionalTrades") : 0;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(TRADE_STATUSES, (Object)this.currentTradesInfo);
            this.field_70180_af.func_187227_b(ADDITIONAL_TRADES, (Object)this.additionalTrades);
            this.deserializeTradeStatuses(this.currentTradesInfo);
        }
    }

    public void func_70071_h_() {
        String currentInfo;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && !(currentInfo = (String)this.field_70180_af.func_187225_a(TRADE_STATUSES)).equals(this.currentTradesInfo)) {
            this.currentTradesInfo = currentInfo;
            int extraTrades = (Integer)this.field_70180_af.func_187225_a(ADDITIONAL_TRADES);
            if (extraTrades != this.additionalTrades) {
                this.additionalTrades = extraTrades;
                this.generateTrades();
            }
            this.deserializeTradeStatuses(currentInfo);
        }
    }

    protected boolean isOverworldNPC() {
        return false;
    }

    protected int getSpawnChanceFactor() {
        return 10;
    }

    private boolean checkSpawnChance(SpawnReason reason) {
        return EntityUtil.isNaturalSpawnReason(reason) || this.getSpawnChanceFactor() <= 1 || this.field_70146_Z.nextInt(this.getSpawnChanceFactor()) == 0;
    }

    protected boolean isValidLightLevel(SpawnReason reason) {
        if (this.field_70170_p.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return true;
        }
        BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b, this.func_226281_cx_());
        if (this.field_70170_p.func_226658_a_(LightType.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return true;
        }
        int light = this.field_70170_p.func_72911_I() ? this.field_70170_p.func_205049_d(blockpos, 10) : (int)this.field_70170_p.func_205052_D(blockpos) * 15;
        return light > this.field_70146_Z.nextInt(8);
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == Items.field_151057_cb) {
            heldStack.func_111282_a(player, (LivingEntity)this, hand);
            return true;
        }
        if (this.func_70089_S() && !player.func_225608_bj_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_213706_dY();
                this.func_70932_a_(player);
                this.openGui(player);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void openGui(PlayerEntity player) {
        this.func_213707_a(player, this.func_145748_c_(), 0);
    }

    public MerchantOffers func_213706_dY() {
        if (this.trades == null) {
            this.generateTrades();
        }
        return this.trades;
    }

    private void generateTrades() {
        Random rand = new Random(1L + this.func_110124_au().getMostSignificantBits() + this.func_110124_au().getLeastSignificantBits());
        NonNullList allTrades = NonNullList.func_191196_a();
        this.trades = new MerchantOffers();
        this.getTradesList((NonNullList<AoATraderRecipe>)allTrades);
        this.maxTradesCount = allTrades.size();
        if (!this.isFixedTradesList()) {
            int newTradesSize = Math.max(rand.nextInt(allTrades.size()), 1);
            if (this.additionalTrades > 0 && newTradesSize < allTrades.size()) {
                newTradesSize = Math.min(newTradesSize + this.additionalTrades, allTrades.size());
            }
            for (int i = 0; i < newTradesSize; ++i) {
                int pick = rand.nextInt(allTrades.size());
                this.trades.add(allTrades.get(pick));
                allTrades.remove(pick);
            }
        } else {
            this.trades.addAll((Collection)allTrades);
        }
    }

    protected abstract void getTradesList(NonNullList<AoATraderRecipe> var1);

    public void setTrades(MerchantOffers trades) {
    }

    public void func_213704_a(MerchantOffer recipe) {
        if (this.isFixedTradesList() || this.trades.size() >= this.maxTradesCount) {
            return;
        }
        recipe.func_222219_j();
        if (!this.field_70170_p.field_72995_K) {
            if (recipe.func_222213_g() >= recipe.func_222214_i()) {
                boolean tradesComplete = true;
                for (MerchantOffer trade : this.trades) {
                    if (trade.func_222217_o()) continue;
                    tradesComplete = false;
                    break;
                }
                if (tradesComplete) {
                    this.addNewTrade();
                }
            }
            this.currentTradesInfo = this.serializeTradeStatuses();
            this.field_70180_af.func_187227_b(TRADE_STATUSES, (Object)this.currentTradesInfo);
            this.field_70180_af.func_187227_b(ADDITIONAL_TRADES, (Object)this.additionalTrades);
        }
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    private void addNewTrade() {
        ++this.additionalTrades;
        this.generateTrades();
    }

    private String serializeTradeStatuses() {
        if (this.trades == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (MerchantOffer trade : this.trades) {
            builder.append("|");
            builder.append(trade.func_222213_g());
        }
        return builder.substring(1);
    }

    private void deserializeTradeStatuses(String string) {
        if (!this.currentTradesInfo.equals(string)) {
            this.currentTradesInfo = string;
        }
        if (this.trades == null) {
            this.generateTrades();
        }
        int tradeIndex = 0;
        if (!this.trades.isEmpty() && !this.currentTradesInfo.isEmpty()) {
            for (String s : this.currentTradesInfo.split("\\|")) {
                MerchantOffer trade = (MerchantOffer)this.trades.get(tradeIndex);
                for (int i = 0; i < Integer.parseInt(s) - trade.func_222213_g(); ++i) {
                    trade.func_222219_j();
                }
                ++tradeIndex;
            }
        }
    }
}

