/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.CyanShotEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class ClunkheadEntity
extends AoARangedMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private int stasisCountdown = 500;

    public ClunkheadEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.8125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2200.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 1 + this.field_70146_Z.nextInt(35);
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_CLUNKHEAD_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_CLUNKHEAD_SHOOT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new CyanShotEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if ((double)EntityUtil.getCurrentHealthPercent((LivingEntity)this) < 0.5) {
            --this.stasisCountdown;
            if (this.stasisCountdown < 100) {
                this.func_70691_i(1.0f);
                this.func_213293_j(0.0, 0.0, 0.0);
                if (this.stasisCountdown == 0) {
                    this.stasisCountdown = 500;
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.clunkhead.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.CLUNKHEAD_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.CLUNKHEAD_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

