/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.packet.packets.ScreenOverlayPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;

public class ConiferonEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);

    public ConiferonEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 3.625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 4000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 25.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_CONIFERON_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_CONIFERON_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CONIFERON_HURT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        LivingEntity target = this.func_70638_az();
        if (target == null) {
            return;
        }
        if (this.field_70146_Z.nextInt(300) == 0) {
            if (!this.field_70170_p.field_72995_K) {
                EntityUtil.applyPotions((Entity)target, new PotionUtil.EffectBuilder(Effects.field_76436_u, 60));
            }
            if (target instanceof ServerPlayerEntity) {
                AoAPackets.messagePlayer((ServerPlayerEntity)target, new ScreenOverlayPacket(ScreenOverlayPacket.Type.CONIFERON_VINES, 70));
            }
        }
        if (!target.func_225608_bj_()) {
            target.func_70024_g(Math.signum(this.func_226277_ct_() - target.func_226277_ct_()) * 0.029, 0.0, Math.signum(this.func_226281_cx_() - target.func_226281_cx_()) * 0.029);
        }
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            double resist = 1.0;
            IAttributeInstance attrib = ((LivingEntity)target).func_110148_a(SharedMonsterAttributes.field_111266_c);
            if (attrib != null) {
                resist -= attrib.func_111126_e();
            }
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 140).level(3));
            target.func_70024_g(this.func_213322_ci().func_82615_a() * 10.5 * resist, this.func_213322_ci().func_82617_b() * 0.5 * resist, this.func_213322_ci().func_82616_c() * 10.5 * resist);
            target.field_70133_I = true;
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.CONIFERON_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.CONIFERON_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

