/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.projectile.mob.CorallusShotEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class CorallusEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private static final DataParameter<Boolean> ENRAGED = EntityDataManager.func_187226_a(CorallusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int shotCooldown = 7;
    private int shootStageTimer = 0;
    private int jumpCooldown = 320;
    private int rageStateCooldown = 200;

    public CorallusEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.72f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ENRAGED, (Object)false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(52.0);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1800.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 25.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.3286;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_CORALLUS_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_CORALLUS_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CORALLUS_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    private void setEnraged(boolean enraged) {
        this.field_70180_af.func_187227_b(ENRAGED, (Object)enraged);
    }

    public boolean isEnraged() {
        return (Boolean)this.field_70180_af.func_187225_a(ENRAGED);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vec3d motion = this.func_213322_ci();
        double motionX = motion.func_82615_a();
        double motionY = motion.func_82617_b();
        double motionZ = motion.func_82616_c();
        if (this.jumpCooldown == 0) {
            motionY = 1.6;
            this.field_70143_R = -100.0f;
            this.jumpCooldown = 320;
            this.shootStageTimer = 60;
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_CORALLUS_TAUNT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        } else {
            --this.jumpCooldown;
        }
        if (this.shootStageTimer > 0) {
            if (this.shotCooldown == 0 && !this.field_70170_p.field_72995_K) {
                List targets = this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(40.0), PlayerUtil::shouldPlayerBeAffected);
                for (PlayerEntity target : targets) {
                    CorallusShotEntity shot = new CorallusShotEntity(this, (LivingEntity)target, 12);
                    shot.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_(), this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    this.field_70170_p.func_217376_c((Entity)shot);
                }
                this.shotCooldown = 10 + this.field_70146_Z.nextInt(15);
            } else {
                --this.shotCooldown;
            }
            --this.shootStageTimer;
        }
        --this.rageStateCooldown;
        if (this.rageStateCooldown <= 0) {
            if (this.isEnraged()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.setEnraged(false);
                }
                this.rageStateCooldown = 200;
            } else {
                if (!this.field_70170_p.field_72995_K) {
                    this.setEnraged(true);
                }
                this.rageStateCooldown = 80;
                EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_76420_g, 80).level(4));
            }
        }
        if (this.func_70090_H()) {
            if (motionX > (double)-1.2f && motionX < (double)1.2f) {
                motionX *= (double)1.2f;
            }
            if (motionZ > (double)-1.2f && motionZ < (double)1.2f) {
                motionZ *= (double)1.2f;
            }
        }
        this.func_213293_j(motionX, motionY, motionZ);
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            target.func_213293_j(this.func_213322_ci().func_82615_a(), -1.799, this.func_213322_ci().func_82616_c());
            if (!this.func_70090_H()) {
                EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76437_t, 100).level(15), new PotionUtil.EffectBuilder(Effects.field_76421_d, 50).level(4));
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd() && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.corallus.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.CORALLUS_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.CORALLUS_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

