/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.CottonCandorShotEntity;
import net.tslat.aoa3.entity.projectile.staff.BaronShotEntity;
import net.tslat.aoa3.entity.projectile.staff.FireflyShotEntity;
import net.tslat.aoa3.entity.projectile.staff.FirestormFallEntity;
import net.tslat.aoa3.entity.projectile.staff.NoxiousShotEntity;
import net.tslat.aoa3.entity.projectile.staff.PoisonShotEntity;
import net.tslat.aoa3.entity.projectile.staff.PrimordialShotEntity;
import net.tslat.aoa3.entity.projectile.staff.WaterShotEntity;
import net.tslat.aoa3.entity.projectile.staff.WitherShotEntity;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class CottonCandorEntity
extends AoAFlyingRangedMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private static final DataParameter<Byte> STAGE = EntityDataManager.func_187226_a(CottonCandorEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int stageCountdown = 100;

    public CottonCandorEntity(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.71875f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STAGE, (Object)0);
    }

    private void changeStage(int stage) {
        this.field_70180_af.func_187227_b(STAGE, (Object)((byte)(stage & 7)));
    }

    public int getStage() {
        return ((Byte)this.field_70180_af.func_187225_a(STAGE)).byteValue();
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 35.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_COTTON_CANDOR_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_COTTON_CANDOR_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_COTTON_CANDOR_HURT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source == DamageSource.field_76380_i) {
            return false;
        }
        if (source.func_76364_f() instanceof IProjectile) {
            IProjectile projectile = (IProjectile)source.func_76364_f();
            switch (this.getStage()) {
                case 0: {
                    if (!(projectile instanceof PrimordialShotEntity)) break;
                    return false;
                }
                case 1: {
                    if (!(projectile instanceof WaterShotEntity)) break;
                    return false;
                }
                case 2: {
                    if (!(projectile instanceof FirestormFallEntity) && !(projectile instanceof FireflyShotEntity) && !(projectile instanceof BaronShotEntity)) break;
                    return false;
                }
                case 3: {
                    if (!(projectile instanceof PoisonShotEntity) && !(projectile instanceof NoxiousShotEntity)) break;
                    return false;
                }
                case 4: {
                    if (!(projectile instanceof WitherShotEntity)) break;
                    return false;
                }
                default: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_COTTON_CANDOR_SHOOT.get();
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new CottonCandorShotEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            --this.stageCountdown;
            if (this.stageCountdown == 0) {
                this.changeStage(this.field_70146_Z.nextInt(5));
                this.stageCountdown = 100;
            }
        }
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 5.0f);
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 5.0f);
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.cottonCandor.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
            if (cause.func_76364_f() instanceof PrimordialShotEntity && (killer.func_184614_ca().func_77973_b() == AoAWeapons.WIND_STAFF.get() || killer.func_184592_cb().func_77973_b() == AoAWeapons.WIND_STAFF.get())) {
                AdvancementUtil.completeAdvancement((ServerPlayerEntity)killer, new ResourceLocation("aoa3", "candyland/when_push_comes_to_shove"), "wind_staff_cotton_candor_kill");
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.COTTON_CANDOR_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.COTTON_CANDOR_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

