/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.boss.XxeusEntity;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.CraexxeusNukeEntity;
import net.tslat.aoa3.entity.projectile.mob.CraexxeusShotEntity;
import net.tslat.aoa3.util.DamageUtil;

public class CraexxeusEntity
extends AoAFlyingRangedMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private int chargeCooldown = 300;

    public CraexxeusEntity(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 3.9f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 10.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_CRAEXXEUS_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_CRAEXXEUS_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CRAEXXEUS_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_CRAEXXEUS_SHOOT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new CraexxeusShotEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, (double)0.15f, 1.0));
        if (!this.field_70170_p.field_72995_K) {
            if (this.chargeCooldown > 0) {
                --this.chargeCooldown;
                if (this.chargeCooldown == 40) {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_CRAEXXEUS_CHARGE.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            } else {
                this.chargeCooldown = 300;
                if (this.func_70638_az() != null) {
                    LivingEntity target = this.func_70638_az();
                    CraexxeusNukeEntity projectile = new CraexxeusNukeEntity(this, BaseMobProjectile.Type.MAGIC);
                    double distanceFactorX = target.func_226277_ct_() - projectile.func_226277_ct_();
                    double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - projectile.func_226278_cu_();
                    double distanceFactorZ = target.func_226281_cx_() - projectile.func_226281_cx_();
                    double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_CRAEXXEUS_NUKE.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
                    projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
                    this.field_70170_p.func_217376_c((Entity)projectile);
                }
            }
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (projectile instanceof CraexxeusNukeEntity) {
            DamageUtil.dealBlasterDamage((LivingEntity)this, target, (Entity)projectile, (float)this.getBaseProjectileDamage() * 3.0f, false);
        } else {
            super.doProjectileEntityImpact(projectile, target);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            XxeusEntity xxeus = new XxeusEntity(this);
            this.field_70170_p.func_217376_c((Entity)xxeus);
            this.func_70106_y();
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.CRAEXXEUS_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.CRAEXXEUS_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

