/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.CreepBombEntity;
import net.tslat.aoa3.entity.projectile.mob.CreepTubeEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class CreepEntity
extends AoARangedMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);

    public CreepEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.53125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 6.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.23;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_CREEPOID_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_CREEPOID_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CREEPOID_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new CreepTubeEntity(this, BaseMobProjectile.Type.OTHER);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_175446_cd() || !this.func_70089_S()) {
            return;
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            CreepBombEntity creepBomb = new CreepBombEntity(this, BaseMobProjectile.Type.OTHER);
            creepBomb.func_70186_c(1 / (this.field_70146_Z.nextInt(15) + 1) * (1 - this.field_70146_Z.nextInt(3)), 4.3f, 1 / (this.field_70146_Z.nextInt(15) + 1) * (1 - this.field_70146_Z.nextInt(3)), 1.6f, 12.0f);
            this.field_70170_p.func_217376_c((Entity)creepBomb);
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (projectile instanceof CreepBombEntity) {
            if (target.func_70097_a(DamageSource.func_188403_a((Entity)projectile, (LivingEntity)this), (float)this.getBaseProjectileDamage() * 2.5f)) {
                this.doProjectileImpactEffect(projectile, target);
            }
        } else {
            super.doProjectileEntityImpact(projectile, target);
        }
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.2f);
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.2f);
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.creep.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.CREEP_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.CREEP_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

