/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class CrystocoreEntity
extends AoAFlyingMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private byte damageType = 0;
    private int changeCooldown = 220;
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(CrystocoreEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public CrystocoreEntity(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 3.625f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.6;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    public int getPhase() {
        return ((Byte)this.field_70180_af.func_187225_a(TYPE)).byteValue();
    }

    private void changeState() {
        this.damageType = (byte)this.field_70146_Z.nextInt(6);
        this.field_70180_af.func_187227_b(TYPE, (Object)this.damageType);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_CRYSTAL_CONSTRUCT_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_CRYSTAL_CONSTRUCT_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CRYSTAL_CONSTRUCT_HURT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.changeCooldown > 0) {
                --this.changeCooldown;
            } else {
                this.changeCooldown = 220;
                this.changeState();
                EntityUtil.applyPotions(this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(10.0), PlayerUtil::shouldPlayerBeAffected), RandomUtil.getRandomSelection(new PotionUtil.EffectBuilder(Effects.field_76436_u, 180).level(2), new PotionUtil.EffectBuilder(Effects.field_76440_q, 180), new PotionUtil.EffectBuilder(Effects.field_76437_t, 180).level(2), new PotionUtil.EffectBuilder(Effects.field_76431_k, 180), new PotionUtil.EffectBuilder(Effects.field_82731_v, 180).level(2), new PotionUtil.EffectBuilder(Effects.field_76421_d, 180).level(2)));
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd() && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.crystocore.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            switch (this.damageType) {
                case 0: {
                    EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76436_u, 180).level(2));
                    break;
                }
                case 1: {
                    EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76440_q, 180));
                    break;
                }
                case 2: {
                    EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76437_t, 180).level(2));
                    break;
                }
                case 3: {
                    EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76431_k, 180));
                    break;
                }
                case 4: {
                    EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 180).level(2));
                    break;
                }
                default: {
                    EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 180).level(2));
                }
            }
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.CRYSTOCORE_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.CRYSTOCORE_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

