/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.packet.packets.ScreenOverlayPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.SpectralShotEntity;
import net.tslat.aoa3.library.scheduling.async.DracyonCleanupTask;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class DracyonEntity
extends AoAFlyingMeleeMob
implements AoARangedAttacker {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);

    public DracyonEntity(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
        this.func_70659_e(3.7f);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.15625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1700.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 25.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_DRACYON_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_DRACYON_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_DRACYON_AMBIENT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(200) == 0 && !this.field_70170_p.func_201675_m().func_177500_n() && this.field_70170_p.func_180495_p(this.func_180425_c()).func_185904_a().func_76222_j()) {
                this.field_70170_p.func_175656_a(this.func_180425_c(), Blocks.field_150355_j.func_176223_P());
                new DracyonCleanupTask(this.field_70170_p, this.func_180425_c()).schedule(5, TimeUnit.SECONDS);
            }
            if (this.field_70146_Z.nextInt(70) == 0 && this.func_70638_az() != null) {
                LivingEntity target = this.func_70638_az();
                SpectralShotEntity projectile = new SpectralShotEntity(this, BaseMobProjectile.Type.MAGIC);
                double distanceFactorX = target.func_226277_ct_() - projectile.func_226277_ct_();
                double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - projectile.func_226278_cu_();
                double distanceFactorZ = target.func_226281_cx_() - projectile.func_226281_cx_();
                double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), (SoundEvent)AoASounds.ENTITY_DRACYON_AMBIENT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
                projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
                this.field_70170_p.func_217376_c((Entity)projectile);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd() && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.dracyon.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof ServerPlayerEntity) {
            AoAPackets.messagePlayer((ServerPlayerEntity)target, new ScreenOverlayPacket(ScreenOverlayPacket.Type.SCRATCHES, 40));
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (DamageUtil.dealBlasterDamage((LivingEntity)this, target, (Entity)projectile, 13.5f, false)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 45));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.DRACYON_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.DRACYON_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

