/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.mob.misc.ElusiveCloneEntity;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class ElusiveEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private final HashSet<ElusiveCloneEntity> summons = new HashSet();
    private int summonCooldown = 300;
    private int teleportCooldown = 300;

    public ElusiveEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.5f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_ELUSIVE_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_ELUSIVE_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_ELUSIVE_HURT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        if (player.func_184586_b(hand).func_77973_b() == AoAItems.NIGHTMARE_FLAKES.get()) {
            if (!this.field_70170_p.func_201670_d() && ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
                ItemUtil.givePlayerItemOrDrop(player, new ItemStack((IItemProvider)AoAItems.GRECKON_REALMSTONE.get()));
                player.func_184586_b(hand).func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.summonCooldown > 0) {
                --this.summonCooldown;
            } else {
                this.summonCooldown = 300;
                ElusiveCloneEntity clone = new ElusiveCloneEntity(this);
                this.field_70170_p.func_217376_c((Entity)clone);
                this.summons.add(clone);
            }
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            } else if (this.func_70638_az() != null) {
                double z;
                double y;
                this.teleportCooldown = 300;
                Vec3d targetLookVec = new Vec3d(this.func_226277_ct_() - this.func_70638_az().func_226277_ct_(), this.func_174813_aQ().field_72338_b + (double)(this.func_213302_cg() / 2.0f) - this.func_70638_az().func_226278_cu_() + (double)this.func_70638_az().func_70047_e(), this.func_226281_cx_() - this.func_70638_az().func_226281_cx_()).func_72432_b();
                double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - targetLookVec.field_72450_a * 16.0;
                if (!this.field_70170_p.func_180495_p(new BlockPos(x, y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - targetLookVec.field_72448_b * 16.0, z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - targetLookVec.field_72449_c * 16.0)).func_200015_d((IBlockReader)this.field_70170_p, new BlockPos(x, y, z)) && !this.field_70170_p.func_180495_p(new BlockPos(x, y + 1.0, z)).func_200015_d((IBlockReader)this.field_70170_p, new BlockPos(x, y + 1.0, z))) {
                    this.func_70634_a(x, y, z);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g());
            if (killer != null) {
                PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.elusive.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
                if (killer instanceof ServerPlayerEntity && killer.func_70644_a(Effects.field_76441_p)) {
                    boolean armourless = true;
                    for (ItemStack stack : killer.func_184193_aE()) {
                        if (stack.func_77973_b() == Items.field_190931_a) continue;
                        armourless = false;
                    }
                    if (armourless) {
                        AdvancementUtil.completeAdvancement((ServerPlayerEntity)killer, new ResourceLocation("aoa3", "abyss/activated_my_trap_card"), "invisible_armourless_elusive_kill");
                    }
                }
            }
            for (ElusiveCloneEntity summon : this.summons) {
                if (summon == null) continue;
                summon.func_70106_y();
            }
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.ELUSIVE_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.ELUSIVE_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

