/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;

public class FlashEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);

    public FlashEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        this.isSlipperyMovement = true;
        this.func_70659_e(3.2f);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 9.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.329;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_IMMORTAL_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_IMMORTAL_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187689_f;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && DamageUtil.isMeleeDamage(source)) {
            if (this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.IMMORTALLIS.type()) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.func_70634_a(235.0, 22.0, 10.0);
                        break;
                    }
                    case 1: {
                        this.func_70634_a(235.0, 22.0, -3.0);
                        break;
                    }
                    case 2: {
                        this.func_70634_a(228.0, 22.0, 3.0);
                    }
                }
            } else {
                int x = (int)this.func_226277_ct_() + (this.field_70146_Z.nextInt(14) - 7);
                int z = (int)this.func_226281_cx_() + (this.field_70146_Z.nextInt(14) - 7);
                this.func_70107_b(x, this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos((double)x, this.func_226278_cu_(), (double)z)).func_177956_o(), z);
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    protected void onAttack(Entity target) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.IMMORTALLIS.type()) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.func_70634_a(235.0, 22.0, 10.0);
                        break;
                    }
                    case 1: {
                        this.func_70634_a(235.0, 22.0, -3.0);
                        break;
                    }
                    case 2: {
                        this.func_70634_a(228.0, 22.0, 3.0);
                    }
                }
            } else {
                int x = (int)this.func_226277_ct_() + (this.field_70146_Z.nextInt(14) - 7);
                int z = (int)this.func_226281_cx_() + (this.field_70146_Z.nextInt(14) - 7);
                this.func_70107_b(x, this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos((double)x, this.func_226278_cu_(), (double)z)).func_177956_o(), z);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }
}

