/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.GrawShotEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class GrawEntity
extends AoAFlyingRangedMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private int pullCountdown = 400;

    public GrawEntity(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.0f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2500.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 4.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_GRAW_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_GRAW_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_GRAW_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        block7: {
            super.func_70071_h_();
            if (!this.func_70089_S()) {
                return;
            }
            if (this.field_70170_p.field_72995_K) break block7;
            if (this.func_226278_cu_() > 110.0) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(-1.5 + (double)this.field_70146_Z.nextInt(3), -4.5, -1.5 + (double)this.field_70146_Z.nextInt(3)));
            }
            --this.pullCountdown;
            if (this.pullCountdown < 60) {
                if (this.pullCountdown <= 0) {
                    this.pullCountdown = 400;
                }
                for (PlayerEntity pl : this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(85.0), PlayerUtil::shouldPlayerBeAffected)) {
                    if (pl.func_225608_bj_()) continue;
                    pl.func_70024_g(Math.signum(this.func_226277_ct_() - pl.func_226277_ct_()) * 0.139, Math.signum(this.func_226278_cu_() - pl.func_226278_cu_()) * 0.04, Math.signum(this.func_226281_cx_() - pl.func_226281_cx_()) * 0.139);
                    pl.field_70133_I = true;
                }
            } else {
                for (PlayerEntity pl : this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(85.0), PlayerUtil::shouldPlayerBeAffected)) {
                    if (pl.func_225608_bj_()) continue;
                    pl.func_70024_g(Math.signum(this.func_226277_ct_() - pl.func_226277_ct_()) * 0.008, Math.signum(this.func_226278_cu_() - pl.func_226278_cu_()) * 0.005, Math.signum(this.func_226281_cx_() - pl.func_226281_cx_()) * 0.008);
                    pl.field_70133_I = true;
                }
            }
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.5f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.5f);
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new GrawShotEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.graw.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.GRAW_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.GRAW_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

