/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.minion.HiveSoldierEntity;
import net.tslat.aoa3.entity.mob.misc.HiveWorkerEntity;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class HiveKingEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private static final DataParameter<Integer> GROWTH_PERCENT = EntityDataManager.func_187226_a(HiveKingEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int growthPercent = 0;

    public HiveKingEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        if (!world.field_72995_K) {
            this.field_70180_af.func_187227_b(GROWTH_PERCENT, (Object)100);
            this.growthPercent = 100;
            this.func_213323_x_();
        }
    }

    public HiveKingEntity(World world, int growthPercent) {
        super((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.HIVE_KING.get()), world);
        this.growthPercent = growthPercent;
        this.field_70180_af.func_187227_b(GROWTH_PERCENT, (Object)growthPercent);
        this.func_70606_j(Math.max(1.0f, this.func_110138_aP() / (100.0f / (float)growthPercent)));
        this.func_213323_x_();
        this.func_94061_f(true);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (worldIn.func_201670_d()) {
            this.growthPercent = 100;
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GROWTH_PERCENT, (Object)this.growthPercent);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == GROWTH_PERCENT) {
            this.func_213323_x_();
        }
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return size.field_220316_b * 0.85f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2500.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 20.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_HIVE_KING_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_HIVE_KING_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_HIVE_KING_AMBIENT.get();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.growthPercent >= 100 ? super.func_184647_J() : null;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public int getGrowthPercent() {
        return this.growthPercent;
    }

    public float func_213355_cm() {
        return this.growthPercent >= 100 ? super.func_213355_cm() : (float)this.growthPercent / 100.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.growthPercent < 100) {
            if (!this.field_70170_p.field_72995_K) {
                this.incrementGrowth();
            } else {
                this.growthPercent = (Integer)this.field_70180_af.func_187225_a(GROWTH_PERCENT);
            }
            this.func_213323_x_();
            if (this.growthPercent == 100) {
                this.func_94061_f(false);
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(500) == 0) {
            HiveWorkerEntity worker = new HiveWorkerEntity(this);
            this.field_70170_p.func_217376_c((Entity)worker);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.growthPercent >= 100) {
            return super.func_70097_a(source, amount);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        return true;
    }

    private void incrementGrowth() {
        ++this.growthPercent;
        this.field_70180_af.func_187227_b(GROWTH_PERCENT, (Object)this.growthPercent);
        this.func_70606_j(this.func_110138_aP() / (100.0f / (float)this.growthPercent));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if ((Integer)this.field_70180_af.func_187225_a(GROWTH_PERCENT) < 100) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        if (this.growthPercent < 100) {
            return;
        }
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.hiveKing.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
            if (killer instanceof ServerPlayerEntity && cause.func_76364_f() instanceof HiveSoldierEntity) {
                AdvancementUtil.completeAdvancement((ServerPlayerEntity)killer, new ResourceLocation("aoa3", "barathos/daddy_issues"), "hive_king_hive_staff_kill");
            }
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.HIVE_KING_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.HIVE_KING_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

