/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class HoronEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);

    public HoronEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.28125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 24.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_HORON_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_HORON_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_HORON_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof ServerPlayerEntity) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)target);
            plData.stats().consumeResource(Resources.ENERGY, 60.0f, true);
            plData.stats().consumeResource(Resources.CREATION, 20.0f, true);
            plData.stats().consumeResource(Resources.SOUL, 20.0f, true);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70089_S()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(60) == 0) {
                WorldUtil.createExplosion((Entity)this, this.field_70170_p, 2.0f);
            }
            if (this.func_70638_az() != null && this.field_70146_Z.nextInt(400) == 0) {
                EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_76437_t, 120).level(4));
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.HORON_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.HORON_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

